/**
 * @package     WT Highlight.js
 * @version     1.1.1
 * @Author      Sergey Tolkachyov, https://web-tolk.ru
 * @copyright   Copyright (C) 2024 Sergey Tolkachyov
 * @license     GNU/GPL3
 * @since       1.0.0
 */
(() => {

    document.addEventListener('DOMContentLoaded', () => {

        let wthighlightjsBtn = document.querySelector('.wthighlightjsBtn');

        // Listen for click event
        wthighlightjsBtn.addEventListener('click', event => {

            event.preventDefault();
            const {
                target
            } = event;

            // const revars_variable_index = target.getAttribute('data-wtrevars-variable');

            if (!Joomla.getOptions('xtd-wthighlightjs')) {
                // Something went wrong!
                // @TODO Close the modal
                return false;
            }

            const {
                editor
            } = Joomla.getOptions('xtd-wthighlightjs');

            let wthighlightjs_textarea  = document.querySelector('#wthighlightjs-textarea');
            let code_language_select =   document.querySelector('[name=highlight_js_language]');

            let wthighlightjs_code = escapeHtmlWtHighlightJs(wthighlightjs_textarea.value);

            window.parent.Joomla.editors.instances[editor].replaceSelection('<pre><code class="language-'+ code_language_select.value + '">' + wthighlightjs_code + '</code></pre>');

            if (window.parent.Joomla.Modal) {
                window.parent.Joomla.Modal.getCurrent().close();
            }
        });

        return true;
    });

    function escapeHtmlWtHighlightJs(unsafe)
    {
        return unsafe
            .replace(/&/g, '&amp;')
            .replace(/</g, '&lt;')
            .replace(/>/g, '&gt;')
            .replace(/"/g, '&quot;')
            .replace(/'/g, '&#x27;');
    }

})();
