<?php
/**
 * @package    WT JoomShopping last seen products
 * @author     Sergey Tolkachyov, info@web-tolk.ru https://web-tolk.ru
 * @copyright  Copyright (C) 2022 Sergey Tolkachyov. All rights reserved.
 * @license    GNU General Public License version 3 or later
 */

namespace Joomla\Module\Wtjshoppinglastseenproducts\Site\Helper;

use Joomla\CMS\Factory;
use Joomla\Component\Jshopping\Site\Model\Productlist;

\defined('_JEXEC') or die;
/**
 * The helper class of a module
 *
 * @since  1.0
 */

class WtjshoppinglastseenproductsHelper{

	/**
	 * Method to get last seen products
	 *
	 * @param   Registry  &$params  Module parameters
	 *
	 * @return  array  Last seen products
	 */
	public static function getLastSeenProducts(&$params) : array
	{

		$app = Factory::getApplication();
        $cookie = $app->getInput()->cookie->get('wt_jshopping_last_seen_products', '', 'string');
        if(!empty($cookie))
        {
            $product_ids = unserialize($cookie);
            if(is_array($product_ids) && count($product_ids) > 0){
                $product_ids = array_unique($product_ids);
                $product_list = new Productlist\ListModel();
                /**
                 * @method getLoadProducts()
                 * @var $filters array - ['products'=> $product_ids]
                 * @var $order string
                 * @var $order_by string
                 * @var $limitstart int
                 * @var $limit int
                 * @var $listProductUpdateData bool
                 */
                return array_reverse($product_list->getLoadProducts(['products'=> $product_ids],'FIELD(prod.product_id, '.implode(',', $product_ids).')',null,0, 0, 1) );
            }
        }

        return [];
	}
}
?>