<?php
/**
 * @package     WT Highlight.js
 * @copyright   (C) 2023 Sergey Tolkachyov <https://web-tolk.ru>
 * @link 		https://web-tolk.ru/dev/joomla-plugins/wt-highlight-js.html
 * @license     GNU General Public License version 3 or later
 */
 
// No direct access to this file
defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Factory;
use Joomla\CMS\Installer\Installer;
use Joomla\CMS\Installer\InstallerHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Filesystem\File;
use Joomla\CMS\Version;
use Joomla\CMS\Uri\Uri;

class pkg_wtspeiginsertInstallerScript{
 

    /**
     * Runs just before any installation action is performed on the component.
     * Verifications and pre-requisites should run in this function.
     *
     * @param  string    $type   - Type of PreFlight action. Possible values are:
     *                           - * install
     *                           - * update
     *                           - * discover_install
     * @param  \stdClass $parent - Parent object calling object.
     *
     * @return void
     */
    public function preflight($type, $parent) 
    {
	    
		// only Joomla 4+
		if(!(new Version())->isCompatible('4.0')){
			return false;	
		}
		
	
    }
	
	
	
	    /**
     * Runs right after any installation action is performed on the component.
     *
     * @param  string    $type   - Type of PostFlight action. Possible values are:
     *                           - * install
     *                           - * update
     *                           - * discover_install
     * @param  \stdClass $parent - Parent object calling object.
     *
     * @return void
     */
	function postflight($type, $installer)
	{
		

		$element = strtoupper($installer->getElement());
		$class = 'col-';
		$web_tolk_site_icon = '';
	
		$smile = '';
		if($type != 'uninstall'){
			$smiles = ['&#9786;','&#128512;','&#128521;','&#128525;','&#128526;','&#128522;','&#128591;'];
			$smile_key = array_rand($smiles, 1);
			$smile = $smiles[$smile_key];
		}

	
		echo "
		<div class='row bg-white' style='margin:25px auto; border:1px solid rgba(0,0,0,0.125); box-shadow:0px 0px 10px rgba(0,0,0,0.125); padding: 10px 20px;'>
		<div class='".$class."8 p-2'>
		<h2>".$smile.Text::_($element."_AFTER_".strtoupper($type))." <br/>".Text::_($element)."</h2>
		".Text::_($element."_DESC");


		echo Text::_($element."_WHATS_NEW");

		echo "</div>
		<div class='".$class."4' style='display:flex; flex-direction:column; justify-content:start;'>
		<img width='200' src='https://web-tolk.ru/web_tolk_logo_wide.png'>
		<p>Joomla Extensions</p>
		<p class='btn-group'>
			<a class='btn btn-sm btn-outline-primary' href='https://web-tolk.ru' target='_blank'>".$web_tolk_site_icon." https://web-tolk.ru</a>
			<a class='btn btn-sm btn-outline-primary' href='mailto:info@web-tolk.ru'><i class='icon-envelope'></i> info@web-tolk.ru</a>
		</p>
		<p><a class='btn btn-sm btn-outline-info' href='https://t.me/joomlaru' target='_blank'>Joomla Russian Community in Telegram</a></p>
		".Text::_($element."_MAYBE_INTERESTING")."
		</div>


		";
		return true;
	}
	
}