<?php
/**
 * @package     WT Highlight.js
 * @copyright   (C) 2023 Sergey Tolkachyov <https://web-tolk.ru>
 * @link        https://web-tolk.ru/dev/joomla-plugins/wt-highlight-js.html
 * @license     GNU General Public License version 3 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Layout\FileLayout;
use Joomla\CMS\Uri\Uri;
use Joomla\Registry\Registry;
use Joomla\String\StringHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Utility\Utility;
use Joomla\Event\SubscriberInterface;


class PlgContentWtspeiginsert extends CMSPlugin
//    implements SubscriberInterface
{
    /**
     * Load the language file on instantiation.
     *
     * @var    boolean
     *
     * @since  3.9.0
     */
    protected $autoloadLanguage = true;

    /**
     * @inheritDoc
     *
     * @return string[]
     *
     * @throws Exception
     * @since 4.1.0
     *
     */
//    public static function getSubscribedEvents(): array
//    {
//        $app = Factory::getApplication();
//
//        $mapping = [];
//
//        if ($app->isClient('site')) {
//            $mapping['onContentPrepare'] = 'onContentPrepare';
//
//        }
//
//        return $mapping;
//    }


    /**
     * Plugin that adds a pagebreak into the text and truncates text at that point
     *
     * @param string $context The context of the content being passed to the plugin.
     * @param object   &$row The article object.  Note $article->text is also available
     * @param mixed    &$params The article params
     * @param integer $page The 'page' number
     *
     * @return  void
     *
     * @since   1.6
     */
    public function onContentPrepare($context, &$row, &$params, $page = 0)
    {
        // Expression to search for.
        $regex = '/{ALBUM\s(.*?)}/i';

//        // Simple performance check to determine whether bot should process further.
//        if (StringHelper::strpos($row->text, 'class="system-pagebreak') === false) {
//            if ($page > 0) {
//                throw new Exception(Text::_('JERROR_PAGE_NOT_FOUND'), 404);
//            }
//
//            return;
//        }

        // Find all instances of plugin and put in $matches.
        $matches = [];
        preg_match_all($regex, $row->text, $matches, PREG_SET_ORDER);

        $all_album_params = $this->params;

        if (count($matches) > 0) {

            // Emulate module params

            HTMLHelper::_('jquery.framework');
            $app = Factory::getApplication();
            $option = $app->input->get('option', '', 'STRING');
            $view = $app->input->get('view', '', 'STRING');
            $doc = Factory::getDocument();
            $doc->addStylesheet(Uri::base(true) . '/components/com_speasyimagegallery/assets/css/style-min.css');
            $doc->addScript(Uri::base(true) . '/components/com_speasyimagegallery/assets/js/script-min.js');
//                $layout = $params->get('album_layout', 'default');
            $show_title = $this->params->get('show_title', 1);
            $show_desc = $this->params->get('show_desc', 1);
            $show_count = $this->params->get('show_count', 1);
            $gutter = $this->params->get('album_gutter', 20) / 2;
            $gutter_sm = $this->params->get('album_gutter_sm', 15) / 2;
            $gutter_xs = $this->params->get('album_gutter_xs', 10) / 2;


            $i = 1;
            foreach ($matches as $match) {
                $album_params = explode(' ', $match[1]);
                foreach ($album_params as $album_param) {
                    $album_param = explode('=', $album_param);
                    $all_album_params->set($album_param[0], $album_param[1]);

                }

                $images = $this->getImages($all_album_params);

                if (!empty($images)) {
                    $id = '.plg-wtspeasyimagegalleryinsert';
                    $i++;
                    $gallery_attribs = '';
                    if ((($option != 'com_speasyimagegallery') && ($view != 'album')) || (($option == 'com_speasyimagegallery') && ($view == 'albums'))) {
                        $doc->addScript(Uri::base(true) . '/components/com_speasyimagegallery/assets/js/speasygallery-main.js');
                        $gallery_attribs = 'data-showtitle="' . $show_title . '" data-showdescription="' . $show_desc . '" data-showcounter="' . $show_count . '"';
                    }

                    // Stylesheet
                    if ($gutter || $gutter_sm || $gutter_xs) {
                        $css = '';
                        if ($gutter) {
                            $css .= $id . ' .speasyimagegallery-row {margin: -' . $gutter . 'px;}';
                            $css .= $id . ' .speasyimagegallery-row > div > .speasyimagegallery-gallery-item {padding: ' . $gutter . 'px;}';
                        }

                        if ($gutter_sm) {
                            $css .= '@media only screen and (max-width : 992px) {';
                            $css .= $id . ' .speasyimagegallery-row {margin: -' . $gutter_sm . 'px;}';
                            $css .= $id . ' .speasyimagegallery-row > div > .speasyimagegallery-gallery-item {padding: ' . $gutter_sm . 'px;}';
                            $css .= '}';
                        }

                        if ($gutter_xs) {
                            $css .= '@media only screen and (max-width : 768px) {';
                            $css .= $id . ' .speasyimagegallery-row {margin: -' . $gutter_xs . 'px;}';
                            $css .= $id . ' .speasyimagegallery-row > div > .speasyimagegallery-gallery-item {padding: ' . $gutter_xs . 'px;}';
                            $css .= '}';
                        }

                        $doc->addStyleDeclaration($css);
                    }


                    $html = ['<div class="mod-speasyimagegallery plg-wtspeasyimagegalleryinsert">'];
                    $html[] = '<div class="speasyimagegallery-gallery clearfix" ' . $gallery_attribs . '>';
                    $layout = new FileLayout('gallery.' . $all_album_params->get('album_layout') . '.row', JPATH_ROOT . '/modules/mod_speasyimagegallery/layouts');
                    $html[] = $layout->render(array('images' => $images, 'params' => $all_album_params));
                    $html[] = '</div></div>';
                } else {
                    $html = ['<div class="alert">' . Text::_('PLG_WTSPEIGINSERT_NO_IMAGES') . '</div>'];
                }

                $row->text = str_replace($match[0], implode('', $html), $row->text);
            }
        }
    }

    /**
     * @param Registry $params
     *
     * @return array|mixed
     *
     * @since 1.0.0
     */
    protected function getImages(Registry $params)
    {
        $album_id = $params->get('album_id', 0);
        $limit = $params->get('album_limit', 8);
        $db = Factory::getDbo();
        $query = $db->getQuery(true);
        $query->select(array('a.*'));
        $query->from($db->quoteName('#__speasyimagegallery_images', 'a'));
        $query->where($db->quoteName('album_id') . ' = ' . $db->quote($album_id));
        $query->where($db->quoteName('state') . ' = ' . $db->quote(1));
        $query->order('a.ordering DESC');
        $query->setLimit($limit);
        $db->setQuery($query);
        return $db->loadObjectList();
    }
}
