<?php
/*
* @version		mod_wt_boostrap4_slider.php 1.0
* @package		Bootstrap 4 image slider for Joomla
* @copyright   Copyright (C) 2020 Sergey Tolkachyov
* @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
*/
defined('_JEXEC') or die;
use Joomla\CMS\Language\Text;

/* Include Yandex Checkout SDK PHP
*  @version 1.5.8 Stable
*  @license MIT
*  https://github.com/yandex-money/yandex-checkout-sdk-php
*/
require __DIR__ . '/lib/autoload.php';
use YooKassa\Client;
use Joomla\CMS\Factory;

class modWtYandexCheckoutDonateHelper{
	public static function getAjax(){
		JSession::checkToken('get') or die( 'Invalid Token' );
		// Get module parameters
		jimport('joomla.application.module.helper');
		$input  = Factory::getApplication()->input;
		$description   = $input->getString('description');
		$amount   = $input->getInt('amount');
		$module_id = $input->getString('module_id');
		$module = JModuleHelper::getModuleById($module_id);
		$params = new JRegistry();
		$params->loadString($module->params);
		$shopId = $params->get('shopId');
		$secretKey = $params->get('secretKey');
		$currency = $params->get('currency');
		$uri = JFactory::getURI();
		$return_url= $uri->toString();

		$client = new Client();
		$client->setAuth($shopId, $secretKey);
		$idempotenceKey = uniqid('', true);
			$payment = $client->createPayment(
				array(
					'amount' => array(
						'value' => $amount,
						'currency' => $currency,
					),
					'confirmation' => array(
						'type' => 'redirect',
						'return_url' => $return_url,
					),
					'capture' => true,
					'description' => $description,
					'save_payment_method' => false
				),
				$idempotenceKey
			);

		$show_message_field = $params->get('show_message_field');
		if($show_message_field == "1"){
			$message   = $input->getString('message');
			$email_to = $params->get('email');
			$mailer = Factory::getMailer();
			$config = Factory::getConfig();
			$sender = array(
				$config->get( 'mailfrom' ),
				$config->get( 'fromname' )
			);

			$mailer->setSender($sender);
			$mailer->addRecipient($email_to);
			$mailer->setSubject(Text::_('MOD_WTYANDEXCHECKOUTDONATE_EMAIL_HEADER').$description);
			$body   = '<h2>'.Text::_('MOD_WTYANDEXCHECKOUTDONATE_EMAIL_HEADER').$description.'</h2>'
				. '<div style="border:1px solid rgba(0,0,0,0.125); padding: 15px; border-radius:7px; box-shadow: 0px 0px 20px #a8a8a8;"><p><strong>'.Text::_('MOD_WTYANDEXCHECKOUTDONATE_EMAIL_PAYMENT_ID').'</strong> '.$payment->id.'</p>'
				. '<p><strong>'.Text::_('MOD_WTYANDEXCHECKOUTDONATE_EMAIL_PAYMENT_STATUS').'</strong> '.$payment->status.'</p>'
				. '<p><strong>'.Text::_('MOD_WTYANDEXCHECKOUTDONATE_EMAIL_PAYMENT_AMOUNT').'</strong> '.$payment->amount->value.'</p>'
				. '<p><strong>'.Text::_('MOD_WTYANDEXCHECKOUTDONATE_EMAIL_PAYMENT_CREATED').'</strong> '.$payment->created_at->format('d-m-Y H:i:s').'</p><hr/>'
				. '<p><strong>'.Text::_('MOD_WTYANDEXCHECKOUTDONATE_LABEL_DESCRIPTION').'</strong> '.$description.'</p>'
				. '<p><strong>'.Text::_('MOD_WTYANDEXCHECKOUTDONATE_LABEL_MESSAGE').'</strong> '.$message.'</p>'
				. '</div>';
			$mailer->isHtml(true);
			$mailer->Encoding = 'base64';
			$mailer->setBody($body);
			$send = $mailer->Send();

		}

		if(!empty($payment->getConfirmation()->getConfirmationUrl())){
			return $payment->getConfirmation()->getConfirmationUrl();
		} else
		{
			return false;
		}

	}//getAjax

}


