/**
 * @copyright  (C) 2018 Open Source Matters, Inc. <https://www.joomla.org>
 * @license    GNU General Public License version 2 or later; see LICENSE.txt
 */
(() => {
  document.addEventListener('DOMContentLoaded', () => {
    // Get the elements
    const elements = document.querySelectorAll('.WtSpeigInsertBtn');

    for (let i = 0, l = elements.length; l > i; i += 1) {
      // Listen for click event
      elements[i].addEventListener('click', event => {
        event.preventDefault();
        const {
          target
        } = event;

        if (!Joomla.getOptions('xtd-wtspeiginsert')) {
          // Something went wrong!
          // @TODO Close the modal
          return false;
        }

        const {
          editor
        } = Joomla.getOptions('xtd-wtspeiginsert');

        const album_id = target.getAttribute('data-album-id');
        let image_limit_field = document.getElementById('wtspeiginsert-image-limit');
        let image_layout_field = document.getElementById('wtspeiginsert-layout');
        const image_limit = image_limit_field.value;
        const gallery_layout = image_layout_field.value;
        let short_code = '{ALBUM album_id='+album_id + ' album_limit='+image_limit+' album_layout='+gallery_layout+'}';

        window.parent.Joomla.editors.instances[editor].replaceSelection(short_code);

        if (window.parent.Joomla.Modal) {
          window.parent.Joomla.Modal.getCurrent().close();
        }
      });
    }
  });
})();
