<?php
/**
 * @package       WT Fancybox web asset
 * @Author        Sergey Sergevnin, Sergey Tolkachyov, https://web-tolk.ru
 * @license       GNU/GPL http://www.gnu.org/licenses/gpl-3.0.html
 * @since         1.0.0
 */

namespace Joomla\Plugin\System\Wtfancybox\Extension;

use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\SubscriberInterface;
use function defined;

defined('_JEXEC') or die;

class Wtfancybox extends CMSPlugin implements SubscriberInterface
{

	protected $allowLegacyListeners = false;


	/**
	 * @inheritDoc
	 *
	 * @return string[]
	 *
	 * @since 4.1.0
	 *
	 * @throws Exception
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			'onAfterRoute' => 'addFancyboxPreset'
		];
	}

	public function addFancyboxPreset(): void
	{
		// Only trigger in frontend
		if (Factory::getApplication()->isClient('site')) {
			/** @var Joomla\CMS\WebAsset\WebAssetManager $wa*/
			$wa = Factory::getDocument()->getWebAssetManager();
			$wa->getRegistry()->addRegistryFile('media/plg_system_wtfancybox/joomla.asset.json');
		}
	}
}
