<?php
/**
 * @package    RadicalMart - WT Custom RadicalMart add to cart
 * @version       1.0.0
 * @Author        Sergey Tolkachyov, https://web-tolk.ru
 * @copyright     Copyright (C) 2025 Sergey Tolkachyov
 * @license       GNU/GPL http://www.gnu.org/licenses/gpl-3.0.html
 * @since         1.0.0
 */

namespace Joomla\Plugin\Radicalmart\Wtcustomradicalmartaddtocart\Extension;

use Exception;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\SubscriberInterface;
use Joomla\Registry\Registry;

\defined('_JEXEC') or die;

class Wtcustomradicalmartaddtocart extends CMSPlugin implements SubscriberInterface
{
    /**
     * Load the language file on instantiation.
     *
     * @var    bool
     *
     * @since  1.0.0
     */
    protected $autoloadLanguage = true;

    /**
     * Returns an array of events this subscriber will listen to.
     *
     * @return  array
     *
     * @since   1.0.0
     */
    public static function getSubscribedEvents(): array
    {
        return [
            'onContentPrepare' => 'onContentPrepare',
        ];
    }

    /**
     * Add added to cart products to category view for to operate with it in template
     *
     * @throws Exception
     *
     * @since  1.0.0
     */
    public function onContentPrepare($event): void
    {
        if ($event->getContext() !== 'com_radicalmart.category') {
            return;
        }

        $category = $event->getItem();
        if (property_exists($category, 'plugins') && !($category instanceof Registry)) {
            $category->plugins = new Registry($category->plugins);
        }

        $cart     = $this->getApplication()
                            ->bootComponent('com_radicalmart')
                            ->getMVCFactory()
                            ->createModel('Cart', 'Site', ['ignore_request' => false]);
        $products = $cart->getProducts();
        $ordered  = [];
        foreach ($products as $product) {
            $ordered[$product->id] = $product->order['quantity'];
        }
        $category->plugins->set('cart_products', $ordered);
    }
}