<?php
/**
 * @package     WebTolk plugin info field
 * @version     1.0.0
 * @Author 		Sergey Tolkachyov, https://web-tolk.ru
 * @copyright   Copyright (C) 2020 Sergey Tolkachyov
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
 * @since 		1.0.0
 */

defined('_JEXEC') or die;
use Joomla\CMS\Date\Date;
use Joomla\CMS\Form\FormHelper;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Language\Text;
use \Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;

FormHelper::loadFieldClass('note');

class JFormFieldWtsmotpravkapochtarukeyinfo extends JFormFieldNote
{

	protected $type = 'wtsmotpravkapochtarukeyinfo';

	/**
	 * Method to get the field input markup for a spacer.
	 * The spacer does not have accept input.
	 *
	 * @return  string  The field input markup.
	 *
	 * @since   1.7.0
	 */
	protected function getInput()
	{

		$plugin = PluginHelper::getPlugin('system','wtlicensemanager');
		$params = json_decode($plugin->params);
		$html = '<p>';
		$domain = @$params->wt_sm_otpravka_pochta_ru_domain;
		$current_domain = parse_url(Uri::current(),PHP_URL_HOST);
		$timezone = Factory::getApplication()->getIdentity()->getTimezone();

		if($domain && ($domain == $current_domain || strpos($domain,$current_domain) > 0) && !empty($params->wt_sm_otpravka_pochta_ru_key)){
			$html .= '<span class="badge badge-success bg-success">OK</span> '.Text::_('PLG_WTLICENSEMANAGER_KEY_DOMAIN_OK').'<br/>';
		}
		if(strpos($domain,$current_domain) === false && $domain != $current_domain && !empty($params->wt_sm_otpravka_pochta_ru_key)){
			$html .= '<span class="badge badge-important bg-danger">'.Text::_('PLG_WTLICENSEMANAGER_KEY_WRONG_DOMAIN_WARN').'</span><br/> ';
		}

		if(empty($domain) && empty($params->wt_sm_otpravka_pochta_ru_key)) {
			$html .= '<span class="badge badge-info bg-info bg-info"><i class="fas fa-info"></i></span> '.Text::_('PLG_WTLICENSEMANAGER_NO_KEY_WARN');
		}

		if(!empty($params->wt_sm_otpravka_pochta_ru_date_start)){

			$html .= '<span class="badge badge-success bg-success">'.Text::_('PLG_WTLICENSEMANAGER_KEY_DATE_START').'</span><span class="badge badge-info bg-info" id="wt_sm_otpravka_pochta_ru_date_start">'.$params->wt_sm_otpravka_pochta_ru_date_start.'</span> ';
		}

		if(!empty($params->wt_sm_otpravka_pochta_ru_date_end)){
			$date_end = new Date($params->wt_sm_otpravka_pochta_ru_date_end);
			$date_end->setTimezone($timezone);
			$date_end->format('d.m.Y');
			//echo $ostatok = new Date($date_end .' - 30days');
			$html .= '<span class="badge badge-success bg-success">'.Text::_('PLG_WTLICENSEMANAGER_KEY_DATE_END').'</span><span class="badge badge-info bg-info" id="wt_sm_otpravka_pochta_ru_date_end">'.$date_end.'</span>';
		}

		$js = '
			jQuery(document).ready(function (){
				
                jQuery("#jform_params_wt_sm_otpravka_pochta_ru_key").keyup(function(){
            			let wt_sm_otpravka_pochta_ru_key = jQuery("#jform_params_wt_sm_otpravka_pochta_ru_key").val();
                        Joomla.request({
                            url: "https://web-tolk.ru/index.php?option=com_ajax&plugin=wt_get_sw_jprojects_key_info&group=system&format=json&element=pkg_smwtotpravkapochtaru&download_key="+wt_sm_otpravka_pochta_ru_key,
                            onSuccess: function(response, xhr){
                                    let result = JSON.parse(response);
                                    let data = JSON.parse(result.data);
                                    console.log (result);

                                    if(data.domain){
                                        jQuery("#jform_params_wt_sm_otpravka_pochta_ru_domain").val(data.domain);
                                    }
                                    if(data.date_start){
                                        jQuery("#jform_params_wt_sm_otpravka_pochta_ru_date_start").val(data.date_start);
                                        jQuery("#wt_sm_otpravka_pochta_ru_date_start").html(data.date_start);
                                    }
                                    if(data.date_end){
                                        jQuery("#jform_params_wt_sm_otpravka_pochta_ru_date_end").val(data.date_end);
                                        jQuery("#wt_sm_otpravka_pochta_ru_date_end").html(data.date_end);
                                    }
                                    if(data.error){
                                        console.error("WT SM Otpravka.pochta.ru key info: " + data.error.code + " - " + data.error.description)
                                        Joomla.renderMessages({"error":["<span class=\"alert-link\">WT SM Otpravka.pochta.ru key info:</span> " + data.error.code + " - " + data.error.description]});
                                        jQuery("#wt_sm_otpravka_pochta_ru_date_end").html("");
                                        jQuery("#jform_params_wt_sm_otpravka_pochta_ru_date_end").val("");
                                        jQuery("#jform_params_wt_sm_otpravka_pochta_ru_date_start").val("");
                                        jQuery("#jform_params_wt_sm_otpravka_pochta_ru_domain").val("");
	                                    jQuery("#wt_sm_otpravka_pochta_ru_date_start").html("");
                                    } else {
                                        Joomla.renderMessages({"success":["<span class=\"alert-link\">WT SM Otpravka.pochta.ru key info:</span> '.Text::_('PLG_WTLICENSEMANAGER_KEY_OK').'"]});
                                    }
   
                                },
                            onError: function(xhr){
	                               console.log (xhr);
	                               Joomla.renderMessages({"warning":["<span class=\"alert-link\">WT SM Otpravka.pochta.ru key info:</span> '.Text::_('PLG_WTLICENSEMANAGER_ERROR_FETCH_DATA_FROM_WEBTOLK').'"]});
                                }
                        });
                        
                });
                
			});
			
			

		';
		Factory::getApplication()->getDocument()->addScriptDeclaration($js);

		return '</p>'.$html;
	}

	/**
	 * @return  string  The field label markup.
	 *
	 * @since   1.7.0
	 */
	protected function getLabel()
	{
		return Text::_('PLG_WTLICENSEMANAGER_KEY_INFO');
	}

	/**
	 * Method to get the field title.
	 *
	 * @return  string  The field title.
	 *
	 * @since   1.7.0
	 */
	protected function getTitle()
	{
		return $this->getLabel();
	}

}
?>