<?php
/**
 * @author      Sergey Tolkachyov
 * @copyright   Copyright (C) 2020 Sergey Tolkachyov. All rights reserved.
 * @url         https://web-tolk.ru
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Http\HttpFactory;
use Joomla\CMS\Plugin\CMSPlugin;

class PlgSystemWtlicensemanager extends CMSPlugin
{
	/**
	 * Load the language file on instantiation.
	 *
	 * @var    boolean
	 * @since  1.2.0
	 */
	protected $autoloadLanguage = true;

	public function onInstallerBeforePackageDownload(&$url, &$headers)
	{
		$uri  = Uri::getInstance($url);
		$host = $uri->getHost();

		if (strpos($host, 'web-tolk.ru') === false)
		{
			return true;
		}
		$download_key = '';
		$element      = $uri->getVar('element');
		if ($element == 'pkg_smwtotpravkapochtaru')
		{
			if (empty($this->params->get('wt_sm_otpravka_pochta_ru_key')))
			{
				Factory::getApplication()->enqueueMessage(Text::_('PLG_WTLICENSEMANAGER_THERE_IS_NO_LICENSE_KEY'), 'error');
			}
			else
			{
				$download_key = $this->params->get('wt_sm_otpravka_pochta_ru_key');
			}
		}
		elseif ($element == 'pkg_wtsmozonrocket')
		{

			if (empty($this->params->get('wt_sm_ozon_rocket_key')))
			{
				Factory::getApplication()->enqueueMessage(Text::_('PLG_WTLICENSEMANAGER_THERE_IS_NO_LICENSE_KEY'), 'error');
			}
			else
			{
				$download_key = $this->params->get('wt_sm_ozon_rocket_key');
			}
		}
		elseif ($element == 'pkg_joomshoppingprodamuspaymentmethod')
		{

			if (empty($this->params->get('pkg_joomshoppingprodamuspaymentmethod_key')))
			{
				Factory::getApplication()->enqueueMessage(Text::_('PLG_WTLICENSEMANAGER_THERE_IS_NO_LICENSE_KEY'), 'error');
			}
			else
			{
				$download_key = $this->params->get('pkg_joomshoppingprodamuspaymentmethod_key');
			}
		}
		$uri->setVar('download_key', $download_key);
		$url = $uri->toString();

		try
		{
			$http     = HttpFactory::getHttp();
			$response = $http->get($url);
			if ($response->code != 200)
			{
				Factory::getApplication()->enqueueMessage(Text::_('PLG_WTLICENSEMANAGER_UPDATE_FAILED'), 'error');
			}
		}
		catch (Exception $e)
		{

		}

		return true;
	}
}
