<?php
/**
* @version      4.16.2 24.05.2017
* @author       MAXXmarketing GmbH, Sergey Tolkachyov
* @package      Jshopping
* @copyright    Copyright (C) 2010 webdesigner-profi.de. All rights reserved.
* @license      GNU/GPL
*/
defined('_JEXEC') or die();
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
?>

<div class="jshop">
	<div class = "jshop cart cartcheckout">
		<details>
			<summary class="border p-2 shadow-sm"><?php echo _JSHOP_ORDER_DETAILS;?> <small class="text-muted">(<?php echo count($this->products).' '. mb_strtolower(Text::_('WT_JSHOP_NUMBER_OF_CART_PRODUCTS')).','; ?> <?php echo mb_strtolower($this->text_total); ?> <?php print formatprice($this->fullsumm)?>

					<?php
					if((int)$this->config->summ_null_shipping > 0 ){
						printf(', '._JSHOP_FROM_PRICE_SHIPPING_FREE, formatprice($this->config->summ_null_shipping, null, 1));
					}
					?>
					)</small></summary>
			<?php
			foreach($this->products as $key_id=>$prod){
				echo $prod['_tmp_tr_before'];
				?>


				<div class="row no-gutters jshop_prod_cart shadow-sm p-3 mb-2 shadow-hover">
					<div class="jshop_img_description_center data col-4 col-sm-2 col-md-1 col-lg-1 col-xl-1 d-flex align-items-center justify-content-center data">
						<a href="<?php print $prod['href']; ?>" title="<?php echo htmlspecialchars($prod['product_name']);?>">
							<?php echo HTMLHelper::image($this->image_product_path.'/'.($prod['thumb_image'] ? $prod['thumb_image'] : $this->no_image), htmlspecialchars($prod['product_name']),'class="jshop_img img-fluid" loading="lazy" width="'.$this->config->image_product_width.'" height="'.$this->config->image_product_height.'"',0); ?>
						</a>
					</div>
					<div class="col-8 col-sm col-md col-lg-6 col-xl-5 d-flex flex-column data product_name data">
						<?php if ($this->config->show_product_code_in_cart): ?>
							<span class="jshop_code_prod">(<?php print $prod['ean']; ?>)</span>
						<?php endif; ?>
						<a href="<?php print $prod['href']?>">
							<?php print $prod['product_name']?>
						</a>

						<?php print $prod['_ext_product_name'] ?>
						<?php if ($prod['manufacturer']!=''){?>
							<div class="manufacturer">
								<?php print _JSHOP_MANUFACTURER?>:
								<span><?php print $prod['manufacturer']?></span>
							</div>
						<?php }?>
						<?php if ($this->config->manufacturer_code_in_cart && $prod['manufacturer_code']){?>
							<div class="manufacturer_code"><?php print _JSHOP_MANUFACTURER_CODE ?>: <span><?php print $prod['manufacturer_code'] ?></span></div>
						<?php }?>
						<?php print sprintAtributeInCart($prod['attributes_value']);?>
						<?php print sprintFreeAtributeInCart($prod['free_attributes_value']);?>
						<?php print sprintFreeExtraFiledsInCart($prod['extra_fields']);?>
						<?php print $prod['_ext_attribute_html']?>
						<?php if ($this->config->show_delivery_time_step5 && $prod['delivery_times_id']){?>
							<div class="deliverytime">
								<?php print _JSHOP_DELIVERY_TIME?>:
								<?php print $this->deliverytimes[$prod['delivery_times_id']]?>
							</div>
						<?php }?>

					</div>
					<div class="col-4 col-sm-2 col-md-2 col-lg-2 data d-flex flex-column ml-lg-auto justify-content-center align-items-lg-end single_price data">
						<span class="text-center"><?php print formatprice($prod['price']); ?></span>
						<?php print $prod['_ext_price_html']?>
						<?php if ($this->config->show_tax_product_in_cart && $prod['tax']>0){?>
							<span class="taxinfo"><?php print productTaxInfo($prod['tax']);?></span>
						<?php }?>
						<?php if ($this->config->cart_basic_price_show && $prod['basicprice']>0){?>
							<div class="basic_price">
								<?php print _JSHOP_BASIC_PRICE?>:
								<span><?php print sprintBasicPrice($prod);?></span>
							</div>
						<?php }?>
					</div>
					<?php /* ?>
			<div class="col-4 col-sm-2 col-md-1 col-lg-1 p-0 data d-flex align-items-center justify-content-center quantity ">
					<span class="qtyval"><?php print $prod['quantity']?></span><?php print $prod['_qty_unit'];?>
			</div>
			<?php */ ?>
					<div class="col-4 col-sm-2 col-md-2 col-lg-2 p-0 data d-flex flex-column align-items-center justify-content-center total_price data">
						<span class="product_price_total h5 text-center"><?php print formatprice($prod['price'] * $prod['quantity']); ?></span>
						<?php if($prod['quantity'] > 1):?>
							<small class="product_price text-muted text-center"><?php echo $prod['quantity'];?> &times; <?php print formatprice($prod['price']); ?> </small>
							<?php print $prod['_ext_price_total_html'] ?>
							<?php if ($this->config->show_tax_product_in_cart && $prod['tax'] > 0) { ?>
								<span class="taxinfo"><?php print productTaxInfo($prod['tax']); ?></span>
							<?php } ?>
						<?php endif;?>


					</div>
				</div>
				<?php
				echo $prod['_tmp_tr_after'];
			}
			?>
		</details>
		<?php if ($this->config->summ_null_shipping > 0 && $this->summ >= $this->config->summ_null_shipping && empty($this->summ_delivery)) : ?>
			<div class = "shippingfree text-center mb-3">
				<i class="far fa-check-circle text-success"></i> <?php echo _JSHOP_SHIPPING_FREE;
//				if(defined())
//				var_dump(defined('_JSHOP_WEIGHT_PRODUCTS'));
				?>
			</div>
		<?php endif; ?>
	</div>

	<?php if ($this->config->show_weight_order){?>
		<div class="weightorder">
			<?php print _JSHOP_WEIGHT_PRODUCTS?>: <span><?php print formatweight($this->weight);?></span>
		</div>
	<?php }?>

	<div class="cartdescr"><?php print $this->checkoutcartdescr;?></div>

	<table class = "jshop jshop_subtotal">
		<?php if (!$this->hide_subtotal){?>
			<tr class="subtotal">
				<td class = "name">
					<?php print _JSHOP_SUBTOTAL ?>
				</td>
				<td class = "value">
					<?php print formatprice($this->summ);?><?php print $this->_tmp_ext_subtotal?>
				</td>
			</tr>
		<?php } ?>

		<?php print $this->_tmp_html_after_subtotal?>

		<?php if ($this->discount > 0){ ?>
			<tr class="discount">
				<td class = "name">
					<?php print _JSHOP_RABATT_VALUE ?><?php print $this->_tmp_ext_discount_text?>
				</td>
				<td class = "value">
					<?php print formatprice(-$this->discount);?><?php print $this->_tmp_ext_discount?>
				</td>
			</tr>
		<?php } ?>

		<?php if (isset($this->summ_delivery)){?>
			<tr class="shipping">
				<td class = "name">
					<?php print _JSHOP_SHIPPING_PRICE;?>
				</td>
				<td class = "value">
					<?php print formatprice($this->summ_delivery);?><?php print $this->_tmp_ext_shipping?>
				</td>
			</tr>
		<?php } ?>

		<?php if (isset($this->summ_package)){?>
			<tr class="package">
				<td class = "name">
					<?php print _JSHOP_PACKAGE_PRICE;?>
				</td>
				<td class = "value">
					<?php print formatprice($this->summ_package);?><?php print $this->_tmp_ext_shipping_package?>
				</td>
			</tr>
		<?php } ?>

		<?php if ($this->summ_payment != 0){ ?>
			<tr class="payment">
				<td class = "name">
					<?php print $this->payment_name;?>
				</td>
				<td class = "value">
					<?php print formatprice($this->summ_payment);?><?php print $this->_tmp_ext_payment?>
				</td>
			</tr>
		<?php } ?>

		<?php if (!$this->config->hide_tax){ ?>
			<?php foreach($this->tax_list as $percent=>$value){?>
				<tr class="tax">
					<td class = "name">
						<?php print displayTotalCartTaxName();?>
						<?php if ($this->show_percent_tax) print formattax($percent)."%"?>
					</td>
					<td class = "value">
						<?php print formatprice($value);?><?php print $this->_tmp_ext_tax[$percent]?>
					</td>
				</tr>
			<?php } ?>
		<?php } ?>

		<tr class="total">
			<td class = "name">
				<span class="h4"><?php print $this->text_total; ?></span>
			</td>
			<td class = "value">
				<span class="h4"><?php print formatprice($this->fullsumm)?></span>
				<?php print $this->_tmp_ext_total?>
			</td>
		</tr>

		<?php print $this->_tmp_html_after_total?>

		<?php if ($this->free_discount > 0){?>
			<tr class="free_discount">
				<td colspan="2" align="right">
					<span class="free_discount">
						<?php print _JSHOP_FREE_DISCOUNT;?>:
						<span><?php print formatprice($this->free_discount); ?></span>
					</span>
				</td>
			</tr>
		<?php }?>
	</table>

	<?php print $this->_tmp_html_after_checkout_cart?>

</div>