<?php 
/**
* @version      4.8.0 13.08.2013
* @author       MAXXmarketing GmbH
* @package      Jshopping
* @copyright    Copyright (C) 2010 webdesigner-profi.de. All rights reserved.
* @license      GNU/GPL
*/
defined('_JEXEC') or die('Restricted access');
?>
<?php if ($this->allow_review){?>
    <?php foreach($this->reviews as $curr){?>
        <div class="review_item card border-0 border-bottom-1">
            <div class="card-header d-flex bg-white">
				<div>
					<span class="review_user mx-1"><?php print $curr->user_name?></span>
					<span class='review_time text-muted'><?php print formatdate($curr->time);?></span>
				</div>
				<?php if ($curr->mark && !$this->config->hide_product_rating){?>
					<div class="review_mark ml-auto"><?php print showMarkStar($curr->mark);?></div>
	            <?php } ?>

			</div>
            <div class="review_text card-body"><?php print nl2br($curr->review)?></div>

        </div>
    <?php }?>
    
    <?php if ($this->display_pagination){?>
        <table class="jshop_pagination">
            <tr>
                <td><div class="pagination"><?php print $this->pagination?></div></td>
            </tr>
        </table>
    <?php }?>
    <?php if ($this->allow_review > 0){?>
    
        <?php JHTML::_('behavior.formvalidation'); ?>
         
        <span class="review"><?php print _JSHOP_ADD_REVIEW_PRODUCT?></span>
        
        <form action="<?php print SEFLink('index.php?option=com_jshopping&controller=product&task=reviewsave');?>" name="add_review" method="post" onsubmit="return validateReviewForm(this.name)" class="">
        
            <input type="hidden" name="product_id" value="<?php print $this->product->product_id?>" />
            <input type="hidden" name="back_link" value="<?php print jsFilterUrl($_SERVER['REQUEST_URI'])?>" />
		    <?php echo JHtml::_('form.token');?>
            
            <div id="jshop_review_write row">

                   <div class="form-group col-md-6 mx-auto">
                        <input type="text" name="user_name" id="review_user_name" class="form-control" value="<?php print $this->user->name?>" placeholder="<?php print _JSHOP_REVIEW_USER_NAME;?>"/>
				   </div>
				<div class="form-group col-md-6 mx-auto">
					<input type="text" name="user_email" id="review_user_email" class="form-control" value="<?php print $this->user->email?>" placeholder="<?php print _JSHOP_REVIEW_USER_EMAIL;?>"/>
				</div>

				<div class="form-group col-md-6 mx-auto">
					<textarea name="review" id="review_review" rows="4" cols="40" class="jshop form-control" placeholder="<?php print _JSHOP_REVIEW_REVIEW;?>"></textarea>
				</div>

                <?php if (!$this->config->hide_product_rating){?>
                <div class = "form-group col-md-6 mx-auto d-flex align-items-center">


                        <?php for($i=1; $i<=$this->stars_count*$this->parts_count; $i++){?>
                            <input name="mark" type="radio" class="star {split:<?php print $this->parts_count?>}" value="<?php print $i?>" <?php if ($i==$this->stars_count*$this->parts_count){?>checked="checked"<?php }?>/>
                        <?php } ?>
	                <?php echo "<span class='ml-1'> - "._JSHOP_REVIEW_MARK_PRODUCT."</span>";?>

                </div>
                <?php }?>
                <?php print $this->_tmp_product_review_before_submit;?>
	                <div class = "form-group col-md-6 mx-auto">
						<button type="submit" class="btn btn-primary button validate"><?php print _JSHOP_REVIEW_SUBMIT?></button>
                    </div>
                </div>
        </form>
    <?php }else{?>
        <div class="review_text_not_login"><?php print $this->text_review?></div>
    <?php } ?>
<?php }?>