<?php
/**
 * @package       Blank page
 * @version       2.0.1
 * @Author        Sergey Tolkachyov
 * @copyright     Copyright (c) 2018 - 2025 Sergey Tolkachyov. All rights reserved.
 * @license       GNU/GPL3 http://www.gnu.org/licenses/gpl-3.0.html
 * @link       https://web-tolk.ru/dev/components/blank-page-component-for-joomla
 * @since         1.0.0
 */

namespace Joomla\Component\Blank\Site\Controller;

use Joomla\CMS\Factory;
use function defined;

defined('_JEXEC') or die;

/**
 * Content Component Controller
 *
 * @since  1.5
 */
class DisplayController extends \Joomla\CMS\MVC\Controller\BaseController
{
    /**
     * Method to display a view.
     *
     * @param   boolean  $cachable   If true, the view output will be cached.
     * @param   boolean  $urlparams  An array of safe URL parameters and their variable types, for valid values see {@link       https://web-tolk.ru/dev/components/blank-page-component-for-joomla
     *
     * @return  DisplayController  This object to support chaining.
     *
     * @since   1.5
     */
    public function display($cachable = false, $urlparams = false)
    {
	    $cachable = true;
	    Factory::getApplication()->getInput()->set('view', 'blank');
	    parent::display($cachable, $urlparams);
        return $this;
    }

}
