<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Joomdle logout landing script
 *
 * @package    auth_joomdle
 * @copyright  2009 Qontori Pte Ltd
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
require_once($CFG->libdir . '/authlib.php');
require_once($CFG->dirroot . '/auth/jmoodle/auth.php');

// It gives a warning if no context set, I guess it does nor matter which we use.
$PAGE->set_context(context_system::instance());

// Grab the GET params.
$token = optional_param('wstoken', '', PARAM_TEXT);
$username = optional_param('username', '', PARAM_TEXT);
$username = strtolower($username);

$auth = new auth_plugin_jmoodle();
/**
 * @var $joomla_token string|false Это должен быть токен юзера, id которого смотрим в настройках
 */
$joomla_token = $auth->getJoomlaUserWsToken();

if (empty($token)) {
    throw new Exception('There is no token specified', '403');
}
if (empty($joomla_token)) {
    throw new Exception('There is no Joomla token specified in JMoodle auth plugin config ', '403');
}

if ($token !== $joomla_token) {
    throw new Exception('Wrong Joomla token specified. You can\'t acceess to Moodle', '403');
}

// First check this is a jmoodle user.
if (!$user = get_complete_user_data('username', $username)) {
    throw new moodle_exception('cannotfinduser', '', '', $username);
}

$user->suspended = 1;
// Force logout.
\core\session\manager::kill_user_sessions($user->id);

exit();