<?php
defined('_JEXEC') or die('Restricted access');
/*
 * This is file to outpout debug info in frontend in JoomShopping checkout for wt_otpravka_pochta_ru shipping method.
 * @package     Jshopping
 * @subpackage  wt_sm_otpravka_pochta_ru
 * @author      Sergey Tolkachyov
 * @copyright   Copyright (C) Sergey Tolkachyov, 2021. All rights reserved.
 * @version     1.3.0
 * @license     GNU General Public License version 3 or later. Only for *.php files!
*/
$doc = \Joomla\CMS\Factory::getDocument();
$doc->addStyleDeclaration("

 details {
		padding: 10px;
	}
 summary {
	padding:10px; background-color: #eee;
  }

.wt-table {
    width: 100%;
    margin-bottom: 1rem;
    color: #212529;
    border-collapse: collapse;
}
.wt-table tbody tr:nth-of-type(odd) {
    background-color: rgba(0,0,0,.05);
}

.wt-table thead th {
    color: #fff;
    background-color: #343a40;
    border-color: #454d55;
}

.wt-table td{
border: 1px solid #dee2e6;
}
");
?>


<details style='border:1px solid #0FA2E6; margin-bottom:5px;'>
	<summary style='background-color:#384148; color:#fff;'>Отладочная информация доставки Почтой России -
		<strong><?php echo $sh_method_name; ?></strong></summary>
	<div class="well well-sm bg-light">
		<p>Минимальный вес отправления = <span class="badge badge-info bg-info"><?php echo $minweight; ?> грамм</span>
		</p>
		<p>Размер НДС = <span class="badge badge-info bg-info">
				<?php
				if ($showNDS == 1)
				{
					echo "Размер НДС:" . $ndsrate;
				}
				else
				{
					echo "Показ НДС выключен";
				}
				?>
			</span>

		<p>Общая стоимость доставки Почтой России с учетом всех коэффициентов <?php echo $prices;?></p>
		<h4>Итоговая формула</h4>
		<table class="table table-bordered table-striped">
			<thead>
			<tr>
				<th>Параметр</th>
				<th>Значение</th>
				<th>Формула</th>
				<th>Промежуточное значение</th>
			</tr>
			</thead>
			<tr>
				<td>Вес корзины</td>
				<td><?php echo $cart->getWeightProducts(); ?></td>
				<td></td>
				<td>-</td>
			</tr>
			<tr>
				<td>Коэффициент поправки веса<br/><small>Например 1,1 - вес упаковки, тары. Умножает вес на этот
						коэффициент. В Тарификатор Почты России отправляется вес с учетом коэффициента.</small></td>
				<td><?php echo $weight_factor; ?> </td>
				<td> <?php echo $cart->getWeightProducts(); ?> * <?php echo $weight_factor; ?> </td>
				<td> <?php echo $cart->getWeightProducts() * $weight_factor; ?></td>
			</tr>
			<tr>
				<td colspan="4">Отправляем в Почту России:<br/>
					<ul>
						<li>Код типа отправления - <?php echo $object_type; ?></li>
						<li>Индекс отправителя - <?php echo $index_from; ?></li>
						<li>Индекс получателя - <?php echo $index_to; ?></li>
						<li>Объявленная стоимость - <?php echo $sumoc; ?> (в копейках)</li>
						<li>Сумма наложенного платежа - <?php echo $sumnp; ?> (в копейках)</li>
						<li>Код типа упаковки - <?php echo $pack; ?></li>
						<li>Вес с учетом коэффициента - <?php echo $weight; ?> (в граммах)</li>
						<li>Код страны - <?php echo $country; ?> (в граммах)</li>
					</ul>
				</td>
			</tr>
			<tr>
				<td colspan="4"><span class="badge badge-info bg-info">url:</span> <?php echo $url; ?></td>
			</tr>
			<tr>
				<td>Цена Почты России</td>
				<td><?php echo $price; ?></td>
				<td>-</td>
				<td><?php echo $price; ?></td>
			</tr>
			<tr>
				<td>Наценка за объявленную стоимость<br/><small><strong>(процент от суммы заказа из <span
									style="color:red">корзины</span>)</strong></small></td>
				<td><?php echo $sm_params['price_tax']; ?>% <br/><small>от <?php echo $summ; ?></small></td>
				<td><?php echo $price; ?> + <?php echo $price_tax; ?></td>
				<td><?php echo($price + $price_tax); ?> </td>
			</tr>
			<tr>
				<td>Общая наценка на способ доставки<br/><small><strong>(Коэффициент, например, 1,1. Умножает общую
							стоимость доставки (число, полученное из Тарификатора) на этот
							коэффициент).</strong></small></td>
				<td><?php echo $general_factor; ?></td>
				<td><?php echo($price + $price_tax); ?> * <?php echo $general_factor; ?></td>
				<td><?php echo $prices; ?> </td>
			</tr>


		</table>
		<details style='border:1px solid #0FA2E6; margin-bottom:5px;'>
			<summary style='background-color:#384148; color:#fff;'>Массив,полученный из Тарификатора</summary>
			<h4>Массив,полученный из Тарификатора</h4>
			<pre>
				<?php print_r($tariff_array); ?>
			</pre>
		</details>

	</div>
</details>
