<?php
/**
 * @package     WT JSwiper
 * @copyright   (C) 2023 Sergey Tolkachyov <https://web-tolk.ru>
 * @link 		https://web-tolk.ru/dev/joomla-plugins/wt-jswiper.html
 * @license     GNU General Public License version 3 or later
 */

defined('_JEXEC') or die;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\SubscriberInterface;


/**
 * Joomla! Log Rotation plugin
 *
 * Rotate the log files created by Joomla core
 *
 * @since  3.9.0
 */
class PlgSystemWtjswiper extends CMSPlugin implements SubscriberInterface
{
	/**
	 * Load the language file on instantiation.
	 *
	 * @var    boolean
	 *
	 * @since  3.9.0
	 */
	protected $autoloadLanguage = true;

	/**
	 * @inheritDoc
	 *
	 * @return string[]
	 *
	 * @since 4.1.0
	 *
	 * @throws Exception
	 */
	public static function getSubscribedEvents(): array
	{
		$app = Factory::getApplication();

		$mapping  = [];

		if ($app->isClient('site'))
		{
			$mapping['onAfterInitialise'] = 'addSwiperPreset';

		}

		return $mapping;
	}


	public function addSwiperPreset()
	{
		// Only trigger in frontend
		if (Factory::getApplication()->isClient('site'))
		{
			/** @var Joomla\CMS\WebAsset\WebAssetManager $wa*/
			$wa = Factory::getDocument()->getWebAssetManager();
			$wa->getRegistry()->addRegistryFile('media/plg_system_wtjswiper/joomla.asset.json');
			return true;
		}
	}
}
