<?php
/**
 * @package       WebTolk plugin info field
 * @version       1.0.0
 * @Author        Sergey Tolkachyov, https://web-tolk.ru
 * @copyright     Copyright (C) 2020 Sergey Tolkachyov
 * @license       GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
 * @since         1.0.0
 */

defined('_JEXEC') or die;

use Joomla\CMS\Form\FormHelper;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Language\Text;
use \Joomla\CMS\Factory;
use Joomla\Registry\Registry;

FormHelper::loadFieldClass('Note');

class JFormFieldModulesinpositionsinfo extends JFormFieldNote
{

	protected $type = 'modulesinpositionsinfo';

	protected function getLabel()
	{
		$data            = $this->form->getData();
		$module_position = $data->get('position');
		$class = [];

		if (!empty($this->class))
		{
			$class[] = $this->class;
		}
		$class       = $class ? ' class="' . implode(' ', $class) . '"' : '';

		if (empty($module_position) || $module_position == 'none')
		{
			$html= 'Не выбрана модульная позиция';
			return '</div><div '.$class.'>' . $html;
		}



		$db    = Factory::getDbo();
		$query = $db->getQuery(true);
		$query->select([$db->quoteName('title'), $db->quoteName('id'), $db->quoteName('published')])
			->from($db->quoteName('#__modules'))
			->where('position = ' . $db->quote($module_position));

		$db->setQuery($query);
		$modules = $db->loadAssocList();


		$title       = $this->element['label'] ? (string) $this->element['label'] : ($this->element['title'] ? (string) $this->element['title'] : '');
		$description = (string) $this->element['description'];
		$title       = '<h4>' . Text::_($title) . '</h4>';
		$html        = [$title];
		$html[]      = '<table class="table table-sm">';
		$html[]      = '<thead><tr><th>'.Text::_('PLG_WT_MODULES_IN_JSHOPPING_MODULESINPOSITIONSINFO_ID').'</th><th>'.Text::_('PLG_WT_MODULES_IN_JSHOPPING_MODULESINPOSITIONSINFO_TITLE').'</th><th>'.Text::_('PLG_WT_MODULES_IN_JSHOPPING_MODULESINPOSITIONSINFO_STATUS').'</th></tr></thead>';
		$html[]      = '<tbody>';
		foreach ($modules as $module)
		{
			$html[] = '<tr>';
			$html[] = '<td>' . $module['id'] . '</td><td>' . $module['title'] . '</td><td>' . ($module['published'] == 1 ? '<span class="badge badge-success bg-success">' . Text::_('JPUBLISHED') . '</span>' : '<span class="badge badge-important bg-danger">' . Text::_('JUNPUBLISHED') . '</span>') . '</td>';
			$html[] = '</tr>';
		}
		$html[] = '</tbody>';
		$html[] = '</table>';
		$html[] = $description;
		$html   = implode('', $html);

		return '</div><div '.$class.'>' . $html;


	}


}

?>