<?php
/**
 * WT Modules in JShopping positions
 * @package     WT JoomShopping Favorite
 * @version     1.1.0
 * @Author      Sergey Tolkachyov, https://web-tolk.ru
 * @copyright   Copyright (C) 2022 Sergey Tolkachyov
 * @license     GNU/GPL 3.0
 * @since       1.0.0
 * @link        https://web-tolk.ru/dev/joomla-plugins/wt-modules-in-jshopping-positions-plagin-vstavki-modulej-joomla-v-joomshopping.html
 */
// No direct access
defined('_JEXEC') or die;

use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Registry\Registry;

class plgSystemWt_modules_in_jshopping_positions extends CMSPlugin
{
	protected $autoloadlanguage = true;

	public function __construct(&$subject, $config)
	{
		parent::__construct($subject, $config);
	}


	/**
	 * Вызывается перед $view->display()
	 *
	 * @param $view JoomShopping Product view object
	 *
	 *
	 * @since 1.0.0
	 */
	public function onBeforeDisplayProductView(&$view)
	{


		$product_modules = $this->params->get('product_modules');

		foreach ($product_modules as $product_module)
		{
			$product_tmp_var = $product_module->product_tmp_var;
			if ($product_tmp_var == 'custom_position')
			{
				$product_tmp_var = $product_module->custom_position;
			}
			$modules = ModuleHelper::getModules($product_module->position);
			foreach ($modules as $module)
			{
				$view->$product_tmp_var .= ModuleHelper::renderModule($module);
			}
		}


	}

	public function onBeforeDisplaywtjshoppingfavoritesView(&$view)
	{

	}

	/**
	 * Вызывается перед $view->display. Изменение $productlist ничего не даёт.
	 *
	 * @param $view        JoomShopping category view
	 * @param $productlist List of products
	 *
	 * @see   \Joomla\Component\Jshopping\Site\Controller\ProductsController::display
	 * @see   \Joomla\Component\Jshopping\Site\Controller\ManufacturerController::view
	 * @see   \Joomla\Component\Jshopping\Site\Controller\CategoryController::view
	 * @see   \Joomla\Component\Jshopping\Site\Controller\VendorController::products
	 * @since 1.0.0
	 */
	public function onBeforeDisplayProductListView($view, &$productlist)
	{
		$category_modules = $this->params->get('category_modules');

		foreach ($category_modules as $category_module)
		{
			if ($category_module->category_or_product == 'category')
			{

				$product_list_tmp_var_category = $category_module->product_list_tmp_var_category;
				if ($product_list_tmp_var_category == 'custom_position')
				{
					$product_list_tmp_var_category = $category_module->custom_position_category;
				}
				$modules = ModuleHelper::getModules($category_module->position);
				foreach ($modules as $module)
				{
					$view->$product_list_tmp_var_category .= ModuleHelper::renderModule($module);
				}
			}
			elseif ($category_module->category_or_product == 'product')
			{
				if (count((array) $view->rows) > 0)
				{
					$product_list_tmp_var_product = $category_module->product_list_tmp_var_product;
					if ($product_list_tmp_var_product == 'custom_position')
					{
						$product_list_tmp_var_product = $category_module->custom_position_product;
					}

					foreach ($view->rows as $product)
					{
						$modules = ModuleHelper::getModules($category_module->position);
						foreach ($modules as $module)
						{
							$product->$product_list_tmp_var_product .= ModuleHelper::renderModule($module);

						}
					}
				}
			}
		}
	}

	/**
	 * Вызывается перед $view->display. Изменение $productlist ничего не даёт.
	 *
	 * @param $view        JoomShopping category view
	 *
	 * @see   \Joomla\Component\Jshopping\Site\Controller\CategoryController::display
	 * @since 1.0.0
	 */
	public function onBeforeDisplayCategoryView($view)
	{
		$category_modules = $this->params->get('category_modules');

		foreach ($category_modules as $category_module)
		{
			if ($category_module->category_or_product == 'category')
			{

				$product_list_tmp_var_category = $category_module->product_list_tmp_var_category;
				if ($product_list_tmp_var_category == 'custom_position')
				{
					$product_list_tmp_var_category = $category_module->custom_position_category;
				}
				$modules = ModuleHelper::getModules($category_module->position);
				foreach ($modules as $module)
				{
					$view->$product_list_tmp_var_category .= ModuleHelper::renderModule($module);
				}
			}
			elseif ($category_module->category_or_product == 'product')
			{
				if (count((array) $view->rows) > 0)
				{
					$product_list_tmp_var_product = $category_module->product_list_tmp_var_product;
					if ($product_list_tmp_var_product == 'custom_position')
					{
						$product_list_tmp_var_product = $category_module->custom_position_product;
					}

					foreach ($view->rows as $product)
					{
						$modules = ModuleHelper::getModules($category_module->position);
						foreach ($modules as $module)
						{
							$product->$product_list_tmp_var_product .= ModuleHelper::renderModule($module);

						}
					}
				}
			}
		}
	}

	/**
	 * Вызывается в корзине товаров.
	 * @param $view
	 *
	 * @see \Joomla\Component\Jshopping\Site\Controller\CartController::view
	 * @since 1.1.0
	 */
	public function onBeforeDisplayCartView($view){

		$checkout_modules = $this->params->get('checkout_modules');
		foreach ($checkout_modules as $checkout_module)
		{
			if ($checkout_module->checkout_section == 'cart')
			{
				$checkout_cart_tmp_var = $checkout_module->checkout_cart_tmp_var_list;
				if ($checkout_cart_tmp_var == 'custom_position')
				{
					$checkout_cart_tmp_var = $checkout_module->custom_position_checkout_cart;
				}
				$modules = ModuleHelper::getModules($checkout_module->position);
				foreach ($modules as $module)
				{
					$view->$checkout_cart_tmp_var .= ModuleHelper::renderModule($module);
				}
			}
		}
	}

	/**
	 * Вызывается при оформлении заказа на шаге заполнения адреса
	 * @param $view
	 *
	 * @see \Joomla\Component\Jshopping\Site\Controller\CheckoutController::step2
	 * @since 1.1.0
	 */
	public function onBeforeDisplayCheckoutStep2View($view){

		$checkout_modules = $this->params->get('checkout_modules');
		foreach ($checkout_modules as $checkout_module)
		{
			if ($checkout_module->checkout_section == 'address')
			{
				$checkout_address_tmp_var = $checkout_module->checkout_address_tmp_var_list;
				if ($checkout_address_tmp_var == 'custom_position')
				{
					$checkout_address_tmp_var = $checkout_module->custom_position_checkout_address;
				}
				$modules = ModuleHelper::getModules($checkout_module->position);
				foreach ($modules as $module)
				{
					$view->$checkout_address_tmp_var .= ModuleHelper::renderModule($module);
				}
			}
		}
	}

	/**
	 * Вызывается при оформлении заказа на шаге заполнения выбора способа доставки
	 * @param $view
	 *
	 * @see \Joomla\Component\Jshopping\Site\Controller\CheckoutController::step4
	 * @since 1.1.0
	 */
	public function onBeforeDisplayCheckoutStep4View($view){

		$checkout_modules = $this->params->get('checkout_modules');

		foreach ($checkout_modules as $checkout_module)
		{
			if ($checkout_module->checkout_section == 'shippings')
			{
				$checkout_shippings_tmp_var = $checkout_module->checkout_shippings_tmp_var_list;
				if ($checkout_shippings_tmp_var == 'custom_position')
				{
					$checkout_shippings_tmp_var = $checkout_module->custom_position_checkout_shippings;
				}
				$modules = ModuleHelper::getModules($checkout_module->position);
				foreach ($modules as $module)
				{
					$view->$checkout_shippings_tmp_var .= ModuleHelper::renderModule($module);
				}
			}
		}
	}

	/**
	 * Вызывается при оформлении заказа на шаге заполнения выбора способа оплаты
	 * @param $view
	 *
	 * @see \Joomla\Component\Jshopping\Site\Controller\CheckoutController::step3
	 * @since 1.1.0
	 */
	public function onBeforeDisplayCheckoutStep3View($view){

		$checkout_modules = $this->params->get('checkout_modules');

		foreach ($checkout_modules as $checkout_module)
		{
			if ($checkout_module->checkout_section == 'payments')
			{
				$checkout_payments_tmp_var = $checkout_module->checkout_payments_tmp_var_list;
				if ($checkout_payments_tmp_var == 'custom_position')
				{
					$checkout_payments_tmp_var = $checkout_module->custom_position_checkout_payments;
				}
				$modules = ModuleHelper::getModules($checkout_module->position);
				foreach ($modules as $module)
				{
					$view->$checkout_payments_tmp_var .= ModuleHelper::renderModule($module);
				}
			}
		}
	}

	/**
	 * Вызывается при оформлении заказа на шаге предпросмотра заказа и комментария к заказу
	 * @param $view
	 *
	 * @see \Joomla\Component\Jshopping\Site\Controller\CheckoutController::step5
	 * @since 1.1.0
	 */
	public function onBeforeDisplayCheckoutStep5View($view){

		$checkout_modules = $this->params->get('checkout_modules');

		foreach ($checkout_modules as $checkout_module)
		{
			if ($checkout_module->checkout_section == 'previewfinish')
			{
				$checkout_previewfinish_tmp_var = $checkout_module->checkout_previewfinish_tmp_var_list;
				if ($checkout_previewfinish_tmp_var == 'custom_position')
				{
					$checkout_previewfinish_tmp_var = $checkout_module->custom_position_checkout_previewfinish;
				}
				$modules = ModuleHelper::getModules($checkout_module->position);
				foreach ($modules as $module)
				{
					$view->$checkout_previewfinish_tmp_var .= ModuleHelper::renderModule($module);
				}
			}
		}
	}

	/**
	 * Вызывается при оформлении заказа на шаге предпросмотра заказа и комментария к заказу
	 * @param $view
	 *
	 * @see \Joomla\Component\Jshopping\Site\Controller\CheckoutController::step5
	 * @since 1.1.0
	 */
	public function onBeforeDisplayCheckoutFinish(&$text, &$order_id){

		$checkout_modules = $this->params->get('checkout_modules');

		foreach ($checkout_modules as $checkout_module)
		{
			if ($checkout_module->checkout_section == 'finish')
			{
				$modules = ModuleHelper::getModules($checkout_module->position);
				foreach ($modules as $module)
				{
					$text .= ModuleHelper::renderModule($module);
				}
			}
		}
	}

}
