<?php

/**
 * @package         WT SP Easy Image Gallery insert
 *
 * @copyright   (C) 2023 Sergey Tolkachyov <https://web-tolk.ru>
 * @license         GNU General Public License version 2 or later;
 * @phpcs           :disable PSR1.Classes.ClassDeclaration.MissingNamespace
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Form;
use Joomla\CMS\Form\FormFactoryInterface;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Object\CMSObject;
use Joomla\Database\DatabaseInterface;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Filesystem\Folder;


// phpcs:disable PSR1.Files.SideEffects
\defined('_JEXEC') or die;
// phpcs:enable PSR1.Files.SideEffects

/**
 * Editor Article button
 *
 * @since  1.5
 */
class PlgButtonWtspeiginsert extends CMSPlugin
{
    /**
     * Load the language file on instantiation.
     *
     * @var    boolean
     * @since  3.1
     */
    protected $autoloadLanguage = true;

    /**
     * Display the button
     *
     * @param string $name The name of the button to add
     *
     * @return  CMSObject|void  The button options as CMSObject, void if ACL check fails.
     *
     * @since   1.5
     */
    public function onDisplay($name)
    {
        $user = Factory::getApplication()->getIdentity();

        // Can create in any category (component permission) or at least in one category
        $canCreateRecords = $user->authorise('core.create', 'com_content')
            || count($user->getAuthorisedCategories('com_content', 'core.create')) > 0;

        // Instead of checking edit on all records, we can use **same** check as the form editing view
        $values = (array)Factory::getApplication()->getUserState('com_content.edit.article.id');
        $isEditingRecords = count($values);

        // This ACL check is probably a double-check (form view already performed checks)
        $hasAccess = $canCreateRecords || $isEditingRecords;
        if (!$hasAccess) {
            return;
        }

        $link = 'index.php?option=com_ajax&plugin=wtspeiginsert&group=editors-xtd&format=html&tmpl=component&'
            . Session::getFormToken() . '=1&amp;editor=' . $name;

        $button = new CMSObject();
        $button->modal = true;
        $button->link = $link;
        $button->text = Text::_('SP Easy Image');
        $button->name = $this->_type . '_' . $this->_name;
        $button->icon = 'fas fa-code';
        $button->iconSVG = '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><!-- Font Awesome Pro 5.15.4 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) --><path d="M278.9 511.5l-61-17.7c-6.4-1.8-10-8.5-8.2-14.9L346.2 8.7c1.8-6.4 8.5-10 14.9-8.2l61 17.7c6.4 1.8 10 8.5 8.2 14.9L293.8 503.3c-1.9 6.4-8.5 10.1-14.9 8.2zm-114-112.2l43.5-46.4c4.6-4.9 4.3-12.7-.8-17.2L117 256l90.6-79.7c5.1-4.5 5.5-12.3.8-17.2l-43.5-46.4c-4.5-4.8-12.1-5.1-17-.5L3.8 247.2c-5.1 4.7-5.1 12.8 0 17.5l144.1 135.1c4.9 4.6 12.5 4.4 17-.5zm327.2.6l144.1-135.1c5.1-4.7 5.1-12.8 0-17.5L492.1 112.1c-4.8-4.5-12.4-4.3-17 .5L431.6 159c-4.6 4.9-4.3 12.7.8 17.2L523 256l-90.6 79.7c-5.1 4.5-5.5 12.3-.8 17.2l43.5 46.4c4.5 4.9 12.1 5.1 17 .6z"/></svg>';
        $button->options = [
            'height' => '300px',
            'width' => '800px',
            'bodyHeight' => 70,
            'modalWidth' => 70,
        ];

        return $button;
    }

    public function onAjaxWtspeiginsert()
    {
        $app = Factory::getApplication();

        if ($app->isClient('site')) {
            Session::checkToken('get') or die(Text::_('JINVALID_TOKEN'));
        }


        $this->showWtspeiginsertAlbumsList();

    }

    /**
     * Показывает форму для модального окна, вызываемого кнопкой редактора.
     *
     * @throws Exception
     * @since 1.0.0
     */
    public function showWtspeiginsertAlbumsList()
    {
        $app = Factory::getApplication();
        $editor = $app->input->getCmd('editor', '');
        if (!empty($editor)) {
            // This view is used also in com_menus. Load the xtd script only if the editor is set!
            $app->getDocument()->addScriptOptions('xtd-wtspeiginsert', ['editor' => $editor]);
        }

        /** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
        $wa = $app->getDocument()->getWebAssetManager();
        $wa->useScript('core')->useStyle('bootstrap.css');
        $wa->registerAndUseScript('admin-wtspeiginsert-modal', 'plg_editors-xtd_wtspeiginsert/admin-wtspeiginsert-modal.js');

        BaseDatabaseModel::addIncludePath(JPATH_ADMINISTRATOR . '/components/com_speasyimagegallery/models');
        $albums_model = BaseDatabaseModel::getInstance('albums', 'SpeasyimagegalleryModel', ['igonre_request' => true]);

        $search = $app->getInput('filter_search','');
        $albums_model->setState('filter.search', $search);

        $categoryId = $app->getInput()->get('filter_category_id','');
        $albums_model->setState('filter.category_id', $categoryId);

        $albums_model->setState('filter.published', 1);
        $albums = $albums_model->getItems();

        $folder_list = Folder::folders(JPATH_SITE . '/modules/mod_speasyimagegallery/layouts/gallery');
        $folder_list = array_combine($folder_list, $folder_list);
        $folder_list = HTMLHelper::_('select.genericlist', $folder_list, 'wtspeiginsert-layout', ['class' => 'form-select'], 'value', 'text', 'default', 'wtspeiginsert-layout', true);


        $categories_model = Factory::getApplication()
            ->bootComponent('com_categories')
            ->getMVCFactory()
            ->createModel('Categories', 'Administrator', ['ignore_request' => true]);
        $categories_model->setState('filter.extension','com_speasyimagegallery');

        $speasyimagegallery_categories = [
          [
            'id' => '',
            'title' => Text::_('JOPTION_SELECT_CATEGORY')
          ]
        ];
        $speasyimagegallery_categories = array_merge($speasyimagegallery_categories, (array) $categories_model->getItems());


        $filter_category = HTMLHelper::_('select.genericlist', $speasyimagegallery_categories, 'filter_category_id', ['class' => 'form-select'], 'id', 'title', $categoryId, 'filter_category_id', true);

        $html = '
        <form action="index.php" class="mb-2 row m-0 bg-secondary" xmlns="http://www.w3.org/1999/html">
            
            <div class="col py-2 ">
            ' .$filter_category.'
            </div>
            <div class="col py-2 input-group">
                <input type="text" name="filter_search" class="form-control" placeholder="'.Text::_('JSEARCH_FILTER').'"/>
                <button type="submit" class="filter-search-bar__button btn btn-primary" aria-label="'.Text::_('JSEARCH_FILTER').'">
                    <span class="filter-search-bar__button-icon icon-search" aria-hidden="true"></span>
                </button>
            </div>

            <input type="hidden" name="option" value="com_ajax"/>
            <input type="hidden" name="plugin" value="wtspeiginsert"/>
            <input type="hidden" name="group" value="editors-xtd"/>
            <input type="hidden" name="format" value="html"/>
            <input type="hidden" name="tmpl" value="component"/>
            <input type="hidden" name="'.Session::getFormToken().'" value="1"/>
            <input type="hidden" name="editor" value="'.$editor.'"/>
            <input type="hidden" name="filter_order" value="id" />
            <input type="hidden" name="filter_order_Dir" value="desc" />
            
        </form>       
        <div class="row">
            <div class="col">
                <label class="form-label me-2" for="wtspeiginsert-image-limit">'.Text::_('PLG_EDITORS-XTD_WTSPEIGINSERT_IMAGE_LIMIT').'</label>
                <input type="number" name="image_limit" id="wtspeiginsert-image-limit" class="form-control" min="1" value="1">
                </div>
                <div class="col">
                
                <label class="form-label me-2" for="wtspeiginsert-layout">'.Text::_('PLG_EDITORS-XTD_WTSPEIGINSERT_LAYOUT').'</label>
                ' . $folder_list . '
                </div>
        </div>
        <hr/>
        
            <div class="row row-cols-2 row-cols-md-3 row-cols-lg-4 row-cols-xl-5">';
        foreach ($albums as $album)
        {
			$insert_button_text        = Text::_('PLG_EDITORS-XTD_WTSPEIGINSERT_TABLE_INSERT_BUTTON');
            $img = HTMLHelper::image($album->image, $album->title, ['class' => 'card-img']);
            $album_title = $album->title;
            $album_id = $album->id;
            $html .= <<<HTML

                        <div class="col mb-3">
                            <div class="card h-100 position-relative">
                            $img
                                <div class="position-absolute w-100 h-100 top-0 bg-dark opacity-75"  style="z-index:2;"></div>
                                <div class="card-img-overlay d-flex flex-column align-items-center justify-content-end" style="z-index:3;">
                                <h5 class="text-white">$album_title</h5>
                                <button class="btn btn-sm btn-warning WtSpeigInsertBtn" data-album-id="$album_id">$insert_button_text</button>
                                </div>
                            </div>
                        </div>

                HTML;

        }

        $html .= '</div>';
        $html .= '<div class="fixed-bottom py-2 bg-white border-top d-flex justify-content-end">           
					<a href="https://web-tolk.ru" target="_blank" class="btn btn-sm d-inline-flex align-items-center">
						<svg width="85" height="18" xmlns="http://www.w3.org/2000/svg">
							 <g>
							  <title>Go to https://web-tolk.ru</title>
							  <text font-weight="bold" xml:space="preserve" text-anchor="start" font-family="Helvetica, Arial, sans-serif" font-size="18" id="svg_3" y="18" x="8.152073" stroke-opacity="null" stroke-width="0" stroke="#000" fill="#0fa2e6">Web</text>
							  <text font-weight="bold" xml:space="preserve" text-anchor="start" font-family="Helvetica, Arial, sans-serif" font-size="18" id="svg_4" y="18" x="45" stroke-opacity="null" stroke-width="0" stroke="#000" fill="#384148">Tolk</text>
							 </g>
						</svg>
					</a>
 				</div>
            

            ';

        $html .= $albums_model->getPagination()->getListFooter();
        echo $html;
    }

    private function getImages($params)
    {
        $album_id = $params->get('album_id', 0);
        $limit = $params->get('album_limit', 8);
        $db = Factory::getContainer()->get(DatabaseInterface::class);
        $query = $db->getQuery(true);
        $query->select(array('a.*'));
        $query->from($db->quoteName('#__speasyimagegallery_images', 'a'));
        $query->where($db->quoteName('album_id') . ' = ' . $db->quote($album_id));
        $query->where($db->quoteName('state') . ' = ' . $db->quote(1));
        $query->order('a.ordering DESC');
        $query->setLimit($limit);
        $db->setQuery($query);
        return $db->loadObjectList();
    }


}
/**
 *    <td class="p-2"><a href="#" class="WtRevarsInsertBtn h4" data-wtrevars-variable="$i">$variable->variable</a><br/><small class="text-muted">$variable->comment</small></td>
 * <td class="p-2">$variable->value</td>
 * <td><button type="button" class="WtRevarsInsertBtn btn btn-sm btn-primary my-auto" data-wtrevars-variable="$i">$insert_button_text</button></td>
 * </tr>
 */