/**
 * @package     WT JShopping products anywhere
 * @copyright   Copyright (C) 2021-2023 Sergey Tolkachyov. All rights reserved.
 * @author      Sergey Tolkachyov - https://web-tolk.ru
 * @link 		https://web-tolk.ru
 * @version 	2.0.0
 * @license     GNU General Public License version 3 or later
 */
(() => {
    document.addEventListener('DOMContentLoaded', () => {
        // Get the elements
        const elements = document.querySelectorAll('.select-link');

        for (let i = 0, l = elements.length; l > i; i += 1) {
            // Listen for click event
            elements[i].addEventListener('click', event => {
                event.preventDefault();
                const {
                    target
                } = event;

                const productd_id = target.getAttribute('data-product-id');
                const tmpl = document.getElementById('wtjshoppingproductsanywhere_layout').value;

                if (!Joomla.getOptions('xtd-wtjshoppingproductsanywhere')) {
                    // Something went wrong!
                    // @TODO Close the modal
                    return false;
                }

                const {
                    editor
                } = Joomla.getOptions('xtd-wtjshoppingproductsanywhere');

                window.parent.Joomla.editors.instances[editor].replaceSelection("{wt_jshop_products product_id=" + productd_id + " tmpl=" + tmpl + "}");

                if (window.parent.Joomla.Modal) {
                    window.parent.Joomla.Modal.getCurrent().close();
                }
            });
        }
    });
})();
