<?php
/**
 * @package    WT JoomShopping last seen products
 * @author     Sergey Tolkachyov, info@web-tolk.ru https://web-tolk.ru
 * @copyright  Copyright (C) 2022 Sergey Tolkachyov. All rights reserved.
 * @license    GNU General Public License version 3 or later
 */

namespace Joomla\Module\Wtjshoppingfavorites\Site\Helper;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\Component\Jshopping\Site\Model\WtproductsModel;
use Joomla\Registry\Registry;

\defined('_JEXEC') or die;
/**
 * The helper class of a module
 *
 * @since  1.0
 */

class WtjshoppingfavoritesHelper{

	/**
	 * Method to get last seen products
	 *
	 * @param   Registry  &$params  Module parameters
	 *
	 * @return  array  Last seen products
	 */
	public static function getProductList(&$params, $app)
	{

        $cookie = $app->input->cookie->get('wtjshoppingfavorites', null, $filter = 'string');
		if(!empty($cookie))
		{
			$product_ids = unserialize($app->input->cookie->get('wtjshoppingfavorites', null, $filter = 'string'));	
		} else {
			$product_ids = [];
		}
		return $product_ids;

	}


    /**
     * @param string $component
     * @param string $view
     *
     *
     * @throws \Exception
     * @since 2.0.0
     */
    public function getItemid($component, $view)
    {
        $items = Factory::getApplication()->getMenu('site')->getItems('component', $component);
        foreach ($items as $item)
        {
            if ($item->query['view'] === $view)
            {
                return $item->id;
            }
        }
    }
}
?>