<?php
/**
 * @package    WT JoomShopping last seen products
 * @author     Sergey Tolkachyov, info@web-tolk.ru https://web-tolk.ru
 * @copyright  Copyright (C) 2022 Sergey Tolkachyov. All rights reserved.
 * @license    GNU General Public License version 3 or later
 */

namespace Joomla\Module\Wtjshoppinglastseenproducts\Site\Helper;
use Joomla\CMS\Factory;
use Joomla\Component\Jshopping\Site\Model\WtproductsModel;

\defined('_JEXEC') or die;
/**
 * The helper class of a module
 *
 * @since  1.0
 */

class WtjshoppinglastseenproductsHelper{

	/**
	 * Method to get last seen products
	 *
	 * @param   Registry  &$params  Module parameters
	 *
	 * @return  array  Last seen products
	 */
	public static function getLastSeenProducts(&$params) : array
	{

		$app = Factory::getApplication();
		$product_ids = unserialize($app->getInput()->cookie->get('wt_jshopping_last_seen_products', [], 'string'));
		if(is_array($product_ids) && count($product_ids) > 0){
            $product_ids = array_unique($product_ids);
			$wt_products = new WtproductsModel;
			$wt_products->loadProductsByIds($product_ids);
			if (!empty($wt_products->products)){
				return array_reverse($wt_products->products);
			}
		}
        return [];
	}
}
?>