<?php
/**
 * @package    WT JoomShopping Last Seen Products
 * @author     Sergey Tolkachyov info@web-tolk.ru https://web-tolk.ru
 * @copyright  Copyright (C) 2022 Sergey Tolkachyov. All rights reserved.
 * @license    GNU General Public License version 3 or later
 */

namespace Joomla\Plugin\Jshoppingproducts\Wt_jshopping_last_seen_products\Extension;

defined('_JEXEC') or die;

use Joomla\CMS\Plugin\CMSPlugin;

/**
 * The base class of plugin
 *
 * @package  WT JoomShopping last seen products
 * @since    1.0
 */
class Wt_jshopping_last_seen_products extends CMSPlugin
{
    /**
     * Method to store last seen products
     *
     * @param object  &$product JoomShopping product
     *
     * @return  void
     *
     * @since   1.0.0
     */
    public function onAfterDisplayProduct(&$product)
    {

        //Получаем cookie с записанными id просмотренных товаров.
        $app = $this->getApplication();

        $cookie = $app->getInput()->cookie->get('wt_jshopping_last_seen_products', '', $filter = 'string');

        if (!empty($cookie)) {
            $cookie = (array)unserialize($cookie);
        } else {
            $cookie = [];
        }
        // id текущего товара
        $product_id = $product->product_id;

        //cookie есть, товара там ещё нет
        if((array_search($product_id,(array)$cookie)) === false){
            $cookie[] = $product_id;
        } else {
            $prod_arr_key = array_search($product_id,$cookie);
            unset ($cookie[$prod_arr_key]);
            $cookie[] = $product_id;
        }

        // Сколько дней хранить в cookie просмотренные товары
        $cookie_period = time() + (int)$this->params->get('cookie_period', '1') * 86400;
        //Пишем итог в cookie
        $app->getInput()->cookie->set(
            'wt_jshopping_last_seen_products',
            serialize($cookie),
            $cookie_period,
            $app->get('cookie_path', '/'),
            $app->get('cookie_domain'),
            $app->isSSLConnection()
        );
    }
}
