<?php
/**
 * @package     Wt Quick Links
 * @copyright   Copyright (C) 2021-2023 Sergey Tolkachyov. All rights reserved.
 * @author      Sergey Tolkachyov - https://web-tolk.ru
 * @link 		https://web-tolk.ru
 * @version 	2.1.2
 * @license     GNU General Public License version 2 or later
 */

namespace Joomla\Plugin\EditorsXtd\Wthighlightjs\Fields;

defined('_JEXEC') or die;

use Joomla\CMS\Form\FormHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Form\Field\ListField;
use Joomla\Filesystem\Folder;

class LanglistField extends ListField
{

	protected $type = 'Langlist';

	protected function getOptions()
	{

		$options = [];

		$languages = Folder::files(JPATH_SITE.'/media/plg_content_wthighlightjs/js/languages');

		foreach ($languages as $language)
		{
			$lang = explode('.',$language);
			$options[] = HTMLHelper::_('select.option', $lang[0], $lang[0]);
			unset($lang);
		}

		return $options;

	}
}
?>