/**
 * @package     System - WT Telegram bot - Content
 * @version     1.0.0
 * @Author      Sergey Tolkachyov, https://web-tolk.ru
 * @copyright   Copyright (C) 2024 Sergey Tolkachyov
 * @license     GNU/GPL 3
 * @since       1.0.0
 */

(() => {
  window.wtTelegrambotContent = () => {

    let article_ids = [];

    let currentUrl = new URL(window.location.href);

    if(currentUrl.searchParams.get('view') === 'article' && currentUrl.searchParams.get('layout') === 'edit'){
      article_ids.push(currentUrl.searchParams.get('id'))
    } else {
      let checkboxes = document.querySelectorAll('#adminForm input[name="cid[]"]:checked');

      if(checkboxes.length === 0){
        alert('There is no articles selected');
        return;
      }
      checkboxes.forEach(checkbox => {
        article_ids.push(checkbox.value);
      });
    }

    Joomla.request({
      url: 'index.php?option=com_ajax&plugin=wttelegrambotcontent&group=system&format=json',
      method: 'POST',
      data: JSON.stringify({
        'article_ids': article_ids,
      }),
      onSuccess: function (response, xhr) {
        //Проверяем пришли ли ответы
        if (response !== '') {
          let result = JSON.parse(response);

          let sent_articles = result.data.sent_articles.length;

          Joomla.renderMessages({
            ['info']: [sent_articles + ' article(s) has been sent to Telegram']
          })
        }
      },
    });

  };
})();