<?php
/**
 * @package     WT Highlight.js
 * @version     1.1.1
 * @Author      Sergey Tolkachyov, https://web-tolk.ru
 * @copyright   Copyright (C) 2024 Sergey Tolkachyov
 * @license     GNU/GPL3
 * @since       1.0.0
 */

namespace Joomla\Plugin\EditorsXtd\Wthighlightjs\Fields;

defined('_JEXEC') or die;

use Joomla\CMS\Form\FormHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Form\Field\ListField;
use Joomla\Filesystem\Folder;

class LanglistField extends ListField
{

	protected $type = 'Langlist';

	protected function getOptions()
	{

		$options = [];

		$languages = Folder::files(JPATH_SITE.'/media/plg_content_wthighlightjs/js/languages','\.js$', false, false, [], ['\.min.js$']);

		foreach ($languages as $language)
		{
			$lang = explode('.',$language);
			$options[] = HTMLHelper::_('select.option', $lang[0], $lang[0]);
			unset($lang);
		}
		return $options;

	}
}