<?php
/**
 * @package     WT Lightbox2.js
 * @copyright   (C) 2023 Sergey Tolkachyov <https://web-tolk.ru>
 * @link 		https://web-tolk.ru/dev/joomla-plugins/wt-lightbox2-js
 * @license     GNU General Public License version 3 or later
 */

defined('_JEXEC') || die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use Joomla\Plugin\System\Wtlightbox2js\Extension\Wtlightbox2js;

return new class () implements ServiceProviderInterface {
	/**
	 * Registers the service provider with a DI container.
	 *
	 * @param   Container  $container  The DI container.
	 *
	 * @return  void
	 *
	 * @since   4.0.0
	 */
	public function register(Container $container)
	{
		$container->set(
			PluginInterface::class,
			function (Container $container) {
				$subject = $container->get(DispatcherInterface::class);
				$config  = (array) PluginHelper::getPlugin('system', 'wtlightbox2js');
				return new Wtlightbox2js($subject, $config);
			}
		);
	}
};