<?php
/**
 * @package    WT Amo CRM library package
 * @version    1.3.0
 * @Author     Sergey Tolkachyov, https://web-tolk.ru
 * @copyright  (c) 2022 - September 2025 Sergey Tolkachyov. All rights reserved.
 * @license    GNU/GPL3 http://www.gnu.org/licenses/gpl-3.0.html
 * @since      1.0.0
 */

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Factory;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use Joomla\Plugin\System\Wt_amocrm\Extension\Wt_amocrm;

defined('_JEXEC') or die;

return new class implements ServiceProviderInterface {
	/**
	 * Registers the service provider with a DI container.
	 *
	 * @param   Container  $container  The DI container.
	 *
	 * @return  void
	 *
	 * @since   1.0.0
	 */
	public function register(Container $container): void
	{
		$container->set(
			PluginInterface::class,
			function (Container $container) {
				$subject = $container->get(DispatcherInterface::class);
				$config = (array) PluginHelper::getPlugin('system', 'wt_amocrm');
				$plugin = new Wt_amocrm($subject, $config);
				$plugin->setApplication(Factory::getApplication());

                $registry = $container->get(Joomla\CMS\WebAsset\WebAssetRegistry::class);
                $registry->addRegistryFile('media/plg_system_wt_amocrm/joomla.asset.json');

				return $plugin;
			}
		);
	}
};