<?php
/**
 * @package    WT Amo CRM library package
 * @version    1.3.1
 * @Author     Sergey Tolkachyov, https://web-tolk.ru
 * @copyright  (c) 2022 - September 2025 Sergey Tolkachyov. All rights reserved.
 * @license    GNU/GPL3 http://www.gnu.org/licenses/gpl-3.0.html
 * @since      1.0.0
 */

namespace Joomla\Plugin\System\Wt_amocrm\Fields;

use Joomla\CMS\Form\FormField;
use Joomla\CMS\Helper\LibraryHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Factory;
use Joomla\CMS\Session\Session;
use Joomla\CMS\Uri\Uri;

defined('_JEXEC') or die;

class ClearrefreshtokenbtnField extends FormField
{

	protected $type = 'Clearrefreshtokenbtn';

	/**
	 * Method to get the field input markup for a spacer.
	 * The spacer does not have accept input.
	 *
	 * @return  string  The field input markup.
	 *
	 * @since   1.0.0
	 */
	protected function getInput()
	{
		$url = new Uri(Uri::root());
		$url->setScheme('https');
		$url->setPath('/administrator/index.php');
		$url->setQuery([
			'option' => 'com_ajax',
			'plugin' => 'wt_amocrm',
			'group' => 'system',
			'format' => 'json',
			'action' => 'clear_refresh_token',
			'action_type' => 'internal',
			Session::getFormToken() => '1'
		]);

		$wa = Factory::getApplication()->getDocument()->getWebAssetManager();
		$wa->addInlineScript("
            document.addEventListener('DOMContentLoaded', () => {
                let clearBtn = document.getElementById('clear_refresh_token_btn');
                clearBtn.addEventListener('click', () => {
                    Joomla.request({
                        url: '".$url->toString()."',
                        method: 'POST',
                        onSuccess: function (response, xhr) {
                            if (response !== '') {
                                let responseData = JSON.parse(response);
                                let answerContainer = document.getElementById('clear_refresh_token_response_container');
                                answerContainer.innerText = responseData.data;
                            }
                        }
                    });
                });
            });
        ");
		$lib_params = LibraryHelper::getParams('Webtolk/Amocrm');
		$refresh_token_date = $lib_params->get('refresh_token_date','');
		$html = ['<div class="d-flex align-items-center">'];

		if (property_exists($refresh_token_date,'date') && !empty($refresh_token_date->date)) {
			$html[] = '<span class="badge bg-success">'.Text::_('PLG_WT_AMOCRM_CLEAR_REFRESH_TOKEN_DATE').':</span> <span class="badge bg-info text-white">'.$refresh_token_date->date.'</span><br/>';
		}

		$html[] = '<button type="button" class="btn btn-sm button-apply btn-warning ms-2" id="clear_refresh_token_btn">'.Text::_('PLG_WT_AMOCRM_CLEAR_REFRESH_TOKEN_BTN_LABEL').'</button>
			<span id="clear_refresh_token_response_container" class="text-success ms-2"></span>
			';
		$html[] = '</div><div class="text-muted fs-6">'.Text::_('PLG_WT_AMOCRM_CLEAR_REFRESH_TOKEN_BTN_DESC').'</div>';


		return implode('', $html);
	}

	/**
	 * @return  string  The field label markup.
	 *
	 * @since   1.0.0
	 */
	protected function getLabel()
	{
		return Text::_(($this->element['label'] ? (string) $this->element['label'] : (string) $this->element['name']));
	}

	/**
	 * @return  string  The field label markup.
	 *
	 * @since   1.0.0
	 */
	protected function getTitle()
	{
		return $this->getLabel();
	}
}
