<?php
/**
 * @package    Fields - WT Layout select
 * @version    1.0.1
 * @Author     Sergey Tolkachyov, https://web-tolk.ru
 * @copyright  Copyright (C) 2026 Sergey Tolkachyov
 * @license    GNU/GPL http://www.gnu.org/licenses/gpl-3.0.html
 * @since  v.1.0.0
 */

declare(strict_types=1);

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Factory;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use Joomla\Plugin\Fields\Wtlayoutselect\Extension\Wtlayoutselect;

\defined('_JEXEC') or die;

return new class() implements ServiceProviderInterface {
    public function register(Container $container): void
    {
        $container->set(
            PluginInterface::class,
            static function (Container $container): Wtlayoutselect {
                $plugin = new Wtlayoutselect(
                    $container->get(DispatcherInterface::class),
                    (array) PluginHelper::getPlugin('fields', 'wtlayoutselect')
                );
                $plugin->setApplication(Factory::getApplication());

                return $plugin;
            }
        );
    }
};



