<?php
/**
 * @package     WT JoomShopping Favorite
 * @version     1.0.0
 * WT JoomShopping Favorites is an alternative wish list (favorite products) for JoomShopping based on coockies.
 * @Author Sergey Tolkachyov, https://web-tolk.ru
 * @copyright   Copyright (C) 2020 Sergey Tolkachyov
 * @license     GNU/GPL 3.0
 * @since 1.0.0
 */
// No direct access
defined( '_JEXEC' ) or die;
use Joomla\CMS\Factory;
jimport('joomla.plugin.plugin');

class plgJshoppingproductsWtjshoppingfavorites extends JPlugin
{

	public function __construct( &$subject, $config )
	{
		parent::__construct( $subject, $config );
        $this->loadLanguage();

    }



    public function onBeforeDisplayProductListView(&$view){
	    $link_css_class = $this->params->get("link_css_class");
	    $product_list_tmp_var = $this->params->get("product_list_tmp_var");
	    $btn_type = $this->params->get("btn_type");
	    if($btn_type == "button"){
	    	$tag = "button";
	    } else {
		    $tag = "a";
	    }
	    $doc = JFactory::getDocument();
	    $doc->addScript("plugins/jshoppingproducts/wtjshoppingfavorites/js/jquery.coockie.js");
	    $doc->addScript("plugins/jshoppingproducts/wtjshoppingfavorites/js/wtjshoppingfavorites.js");

		$rows = $view->rows;
	    $app = JFactory::getApplication();
	    $cookie = unserialize($app->input->cookie->get('wtjshoppingfavorites', null, $filter = 'string'));

		foreach ($rows as $row){
			$product_id = $row->product_id;
				if(!empty($cookie)){

					if(($key = array_search($product_id,(array)$cookie)) !== false){
						$selected = "selected";
					} else{
						$selected = "";
					}
				}

				$row->$product_list_tmp_var .= "<".$tag." ".(($tag == "a")? "href='#'":'type="button"')."  class='".$link_css_class." ".$selected."' id='favorite_button".$product_id."' data-favorite='".$product_id."'><i class=\"".$this->params->get("btn_icon_css_class")."\"></i></".$tag.">";
			}

    }

	public function onBeforeDisplayProductView(&$view){
		$link_css_class = $this->params->get("in_product_link_css_class");
		$product_list_tmp_var = $this->params->get("product_tmp_var");
		$btn_type = $this->params->get("in_product_btn_type");
		if($btn_type == "button"){
			$tag = "button";
		} else {
			$tag = "a";
		}
		$doc = Factory::getDocument();
		$doc->addScript("plugins/jshoppingproducts/wtjshoppingfavorites/js/jquery.coockie.js");
		$doc->addScript("plugins/jshoppingproducts/wtjshoppingfavorites/js/wtjshoppingfavorites.js");

		$app = Factory::getApplication();
		$cookie = unserialize($app->input->cookie->get('wtjshoppingfavorites', null, $filter = 'string'));
		$product_id = $view->product->product_id;
			if(!empty($cookie)){

				if(($key = array_search($product_id,(array)$cookie)) !== false){
					$selected = "selected";
				} else{
					$selected = "";
				}
			}

			$view->$product_list_tmp_var .= "<".$tag." ".(($tag == "a")? "href='#'":'type="button"')."  class='".$link_css_class." ".$selected."' id='favorite_button".$product_id."' data-favorite='".$product_id."'><i class=\"".$this->params->get("btn_icon_css_class")."\"></i></".$tag.">";

	}


public function onConstructJshopWtFavorite($product){
	$link_css_class = $this->params->get("link_css_class");
	$product_list_tmp_var = $this->params->get("product_list_tmp_var");
	$btn_type = $this->params->get("in_product_btn_type");
	if($btn_type == "button"){
		$tag = "button";
	} else {
		$tag = "a";
	}
	$doc = JFactory::getDocument();
	$doc->addScript("plugins/jshoppingproducts/wtjshoppingfavorites/js/jquery.coockie.js");
	$doc->addScript("plugins/jshoppingproducts/wtjshoppingfavorites/js/wtjshoppingfavorites.js");
	$product_id = $product->product_id;
	$app = JFactory::getApplication();
	$cookie = unserialize($app->input->cookie->get('wtjshoppingfavorites', null, $filter = 'string'));
	if(!empty($cookie)){

		if(($key = array_search($product_id,(array)$cookie)) !== false){
			$selected = "selected";
		} else{
			$selected = "";
		}
	}

	$product->$product_list_tmp_var = "<".$tag." ".(($tag == "a")? "href='#'":'')."  class='".$link_css_class." ".$selected."' id='favorite_button".$product_id."' data-favorite='".$product_id."'><i class=\"".$this->params->get("btn_icon_css_class")."\"></i></".$tag.">";
}

public function onBeforeDisplaywtjshoppingfavoritesView(&$view){
	$doc = JFactory::getDocument();
	$js = "
		jQuery('document').ready(function(){
		    jQuery('body').addClass('wtjshoppingfavoritesView');
		    
		    
		    jQuery('.wtjshoppingfavoritesView .block_product').each(function(index){
				let product_id = jQuery(this).find('[data-favorite]').attr('data-favorite'); 
				jQuery(this).attr('data-wt-jshop-favorite',product_id);
		    });
		});
	";
	$doc->addScriptDeclaration($js);

}

	public function onAjaxWtjshoppingfavorites(){
		$app = Factory::getApplication();   // equivalent of $app = JFactory::getApplication();
		$product_id = $app->input->post->get("product_id","","int");
		$cookie = $app->input->post->get("cookie","","raw");
		$product_decode = unserialize(stripcslashes($cookie));
		if(!isset($cookie)) {
			if(($key = array_search($product_id,(array)$product_decode)) === false){
			$product_info = array($product_id);
			$product_encode = serialize($product_info);
			$output = json_encode(array($product_encode,"added"=>true));

			echo $output;

			} else {
				echo null;
			}
		}else {
			if(($key = array_search($product_id,(array)$product_decode)) !== false){
				unset($product_decode[$key]);
				$product_encode = serialize($product_decode);
				$output = json_encode(array($product_encode,"added"=>false));
				echo $output;
			} else {
				$product_decode[] = $product_id;
				$product_encode = serialize($product_decode);
				$output = json_encode(array($product_encode,"added"=>true));
				echo $output;
			}
		}
	}
}
