<?php
/**
 * @package     WT JoomShopping Favorite
 * @version     1.0.1
 * WT JoomShopping Favorites is an alternative wish list (favorite products) for JoomShopping based on coockies.
 * @Author Sergey Tolkachyov, https://web-tolk.ru
 * @copyright   Copyright (C) 2020 Sergey Tolkachyov
 * @license     GNU/GPL 3.0
 * @since 1.0.0
 */

use Joomla\CMS\Factory;

defined('_JEXEC') or die;

$moduleId = $module->id;

$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'), ENT_COMPAT, 'UTF-8');
$doc = Factory::getDocument();
/*
 * Take a css file for tmpl with the same name form media folder
 */
if(!empty($params->get('layout')))
{
	$tmpl_css = explode(':', $params->get('layout'));
	$tmpl_css_file = $tmpl_css[1];
	if(file_exists('media/mod_wtjshoppingfavorites/css/'.$tmpl_css_file.'.css')){
		$doc->addStyleSheet('media/mod_wtjshoppingfavorites/css/'.$tmpl_css_file.'.css');
	}
} else {
	$doc->addStyleSheet('media/mod_wtjshoppingfavorites/css/default.css');
}

$app = Factory::getApplication();
$product_ids = unserialize($app->input->cookie->get('wtjshoppingfavorites', null, $filter = 'string'));
if($product_ids == false){
	unset($product_ids);
}
if(!function_exists('getItemid')){

	function getItemid( $component, $view )
	{
		$items = JFactory::getApplication()->getMenu( 'site' )->getItems( 'component', $component );
		foreach ( $items as $item ) {
			if($item->query['view'] === $view){
				return $item->id;
			}
		}
	}
}


$itemid = getItemid( 'com_jshopping', 'wtjshoppingfavorites' );
if(empty($itemid) || is_null($itemid)){
	$itemid = "&Itemid=0";
} else {
	$itemid = "&Itemid=".$itemid;
}

$plugin = JPluginHelper::getPlugin('jshoppingproducts', 'wtjshoppingfavorites');
if ($plugin) {
    $pluginParams = new JRegistry($plugin->params);
	$btn_icon_css_class = $pluginParams->get("btn_icon_css_class");
}

require JModuleHelper::getLayoutPath('mod_wtjshoppingfavorites', $params->get('layout', 'default'));