<?php
/**
 * @package     WT JoomShopping Favorite
 * @version     1.0.0
 * WT JoomShopping Favorites is an alternative wish list (favorite products) for JoomShopping based on coockies.
 * @Author Sergey Tolkachyov, https://web-tolk.ru
 * @copyright   Copyright (C) 2020 Sergey Tolkachyov
 * @license     GNU/GPL 3.0
 * @since 1.0.0
 */

defined( '_JEXEC' ) or die( 'Restricted access' );
jimport('joomla.application.component.controller');

class JshoppingControllerwtjshoppingfavorites extends JshoppingControllerBase{

  function display($cachable = false, $urlparams = false){
	  	    $this->view();
		}
						

		function view()
		{
			$user        = JFactory::getUser();
			$jshopConfig = JSFactory::getConfig();
			$dispatcher  = JDispatcher::getInstance();
			$lang        = JFactory::getLanguage();
			$lang->load('plg_jshoppingproducts_wtjshoppingfavorites', JPATH_ADMINISTRATOR);


			JPluginHelper::importPlugin('jshoppingproducts');
			$dispatcher = JDispatcher::getInstance();
			$dispatcher->trigger('onBeforeDisplayWtjshoppingfavorites', array(&$this));
			$view_name   = "wtjshoppingfavorites";
			$view_config = array("template_path" => JPATH_COMPONENT . "/templates/" . $jshopConfig->template . "/" . $view_name);
			$view        = $this->getView($view_name, getDocumentType(), '', $view_config);
			$view->setLayout("wtjshoppingfavorites");
			$view->assign('config', $jshopConfig);
			$app = JFactory::getApplication();
			$product_ids = unserialize($app->input->cookie->get('wtjshoppingfavorites', null, $filter = 'string'));
				if(!empty($product_ids)){
						$product     = JSFactory::getTable('product', 'jshop');
						$category    = JSFactory::getTable('category', 'jshop');
						$productlist = JSFactory::getModel('productList', 'jshop');


						foreach ($product_ids as $product_id)
						{
							$product->load($product_id);
							$category_id = $product->getCategory();
							JSFactory::getModel('productShop', 'jshop')->storeEndPages();
							$category->load($category_id);
							JshopHelpersMetadata::category($category);
							$productlist->setModel($category);
							$productlist->load();
							$products = $productlist->getProducts();
							for ($i = 0; $i < count($products); $i++)
							{
								if ($products[$i]->product_id == $product_id)
								{
									$dispatcher->trigger('onConstructJshopWtFavorite', array(&$products[$i]));
									$prods[] = $products[$i];
								}
							}
						}
						$view->assign('rows', $prods);
						$view->assign('config', $jshopConfig);
						$view->config->show_sort_product          = "0"; //Отключаем показ фильтров и сортировки
						$view->config->show_count_select_products = "0";
						$view->assign('template_block_list_product', $productlist->getTmplBlockListProduct());
						$view->assign('template_no_list_product', $productlist->getTmplNoListProduct());
						$view->assign('template_block_form_filter', $productlist->getTmplBlockFormFilter());
						$view->assign('template_block_pagination', $productlist->getTmplBlockPagination());
						$view->assign('count_product_to_row', $productlist->getCountProductsToRow());
						$view->assign('image_category_path', $jshopConfig->image_category_live_path);
						$view->assign('noimage', $jshopConfig->noimage);
						$view->assign('count_category_to_row', $category->getCountToRow());
						$view->assign('shippinginfo', SEFLink($jshopConfig->shippinginfourl, 1));
						$view->assign('total', $productlist->getTotal());

				} else {
					$view->assign('config', $jshopConfig);
				}
				$document = JFactory::getDocument();
				appendPathWay(JText::_('WT_JSHOPPING_FAVORITES'));
				$document->setTitle(JText::_('WT_JSHOPPING_FAVORITES'));




        $dispatcher->trigger('onBeforeDisplaywtjshoppingfavoritesView', array(&$view));
		$view->display();
//        //if ($ajax) die();
    }

}
?>