<?php
/**
 * Модель для работы расширений [Web-tolk.ru](https://web-tolk.ru):
 * @version      1.0.0 Sept 2021
 * @author       Sergey Tolkachyov
 * @package      Jshopping
 * @copyright    Copyright (C) 2021 Sergey Tolkachyov. All rights reserved.
 * @license      GNU/GPL
 *
 */
defined('_JEXEC') or die();

use Joomla\CMS\Plugin\PluginHelper;

class jshopWtproducts
{

	/**
	 * Подсчитывает количество товаров в массиве
	 * @return int
	 *
	 * @since 1.0.0
	 */
	public function getTotal() : int
	{
		if (!empty($this->products))
		{
			return count($this->products);
		} else{
			return 0;
		}
	}

	/**
	 * Функция выбирает товары JoomShopping из базы данных по списку id
	 * @param   array  $product_ids Простой одномерный массив [1, 2, 3, ...]
	 *
	 * @return void
	 *
	 * @since 1.0.0
	 */
	public function loadProductsByIds(array $product_ids) : void
	{

		$lang = JSFactory::getLang();

		if (count($product_ids) > 0)
		{
			$dispatcher = JDispatcher::getInstance();
			$query      = "SELECT * FROM `#__jshopping_products` AS prod
                  LEFT JOIN `#__jshopping_products_to_categories` AS pr_cat USING (product_id)
                  WHERE prod.product_id IN(" . implode(',', $product_ids) . ") AND prod.product_publish=1 ";
			$db         = JFactory::getDBO();
			$db->setQuery($query);

			$products = $db->loadObjectList();

			// Добавляем вендоров, производителей, пути к картинкам и т.д.
			// Второй параметр - setUrl - добавляет в объект товара ссылки на товар и на покупку (в корзину)
			$products = listProductUpdateData($products, 1);

			$dispatcher->trigger('onBeforeDisplayProductList', array(&$products));

			foreach ($products as $product)
			{
				$name                       = $lang->get('name');
				$product->name              = $product->$name;
				$short_description          = $lang->get('short_description');
				$product->short_description = $product->$short_description;
				$description                = $lang->get('description');
				$product->description       = $product->$description;
			}
			// Готовый массив
			$this->products = $products;

		}

	}

	/**
	 * Функция добавляет кнопку избранного для избранных товаров.
	 * Для WT JoomShopping Favorites. Начиная с версии 1.2.0.
	 * Настройки берутся из плагина WT JoomShopping favorites группы jshoppingproducts
	 * @return void
	 * @since 1.0.0
	 */
	public function addWtFavoritesButtonToProducts():void
	{

		// Если включен плагин добавления в избранное

		if (PluginHelper::isEnabled('jshoppingproducts', 'wtjshoppingfavorites') === true)
		{

			$plugin               = PluginHelper::getPlugin('jshoppingproducts', 'wtjshoppingfavorites');
			$params               = (!empty($plugin->params) ? json_decode($plugin->params) : '');
			$link_css_class       = $params->link_css_class;
			$product_list_tmp_var = $params->product_list_tmp_var;
			$btn_type             = $params->in_product_btn_type;
			if ($btn_type == "button")
			{
				$tag = "button";
			}
			else
			{
				$tag = "a";
			}
			if (count($this->products) > 0)
			{

				foreach ($this->products as $product)
				{
					$product->$product_list_tmp_var = "<" . $tag . " " . (($tag == "a") ? "href='#'" : '') . "  class='" . $link_css_class . " selected' id='favorite_button" . $product->product_id . "' data-favorite='" . $product->product_id . "'><i class=\"" . $params->btn_icon_css_class . "\"></i></" . $tag . ">";
				}
			}
		}
	}


	/**
	 * Функция назначает layout в шаблоне для списка товаров
	 * @return string
	 *
	 * @since 1.0.0
	 */
	public function getTmplBlockListProduct(): string
	{
		return JSFactory::getConfig()->default_template_block_list_product;
	}

	/**
	 * Функция назначает layout в шаблоне для списка товаров, когда нет товаров в категории
	 * @return string
	 *
	 * @since 1.0.0
	 */
	public function getTmplNoListProduct(): string
	{
		return JSFactory::getConfig()->default_template_no_list_product;
	}

	/**
	 * Функция назначает layout для стандартных фильтров JoomShopping в шаблоне для списка товаров
	 * @return string
	 *
	 * @since 1.0.0
	 */
	public function getTmplBlockFormFilter(): string
	{
		return JSFactory::getConfig()->default_template_block_form_filter_product;
	}

	/**
	 * Функция назначает layout пагинации в шаблоне для списка товаров
	 * @return string
	 *
	 * @since 1.0.0
	 */
	public function getTmplBlockPagination(): string
	{
		return JSFactory::getConfig()->default_template_block_pagination_product;
	}

}