<?php
/**
 * @package    WT JoomShopping last seen products
 * @author     Sergey Tolkachyov, info@web-tolk.ru https://web-tolk.ru
 * @copyright  Copyright (C) 2021 Sergey Tolkachyov. All rights reserved.
 * @license    GNU General Public License version 3 or later
 */
defined('_JEXEC') or die();
use Joomla\CMS\Factory;
use \Joomla\CMS\MVC\Model\BaseDatabaseModel;
/**
 * The helper class of a module
 *
 * @since  1.0
 */
class ModWtJshoppingLastSeenProducts
{
	/**
	 * Method to get last seen products
	 *
	 * @param   Registry  &$params  Module parameters
	 *
	 * @return  array  Last seen products
	 */
	public static function getLastSeenProducts(&$params)
	{

		$app = Factory::getApplication();
		$product_ids = unserialize($app->input->cookie->get('wt_jshopping_last_seen_products', null, 'string'));

		if(is_array($product_ids) && count($product_ids) > 0){

		BaseDatabaseModel::addIncludePath(JPATH_SITE.'/components/com_jshopping/models');
		$wt_products = JModelLegacy::getInstance('wtproducts', 'jshop');
		$wt_products->loadProductsByIds($product_ids);

			if (!empty($wt_products->products)){
				return array_reverse($wt_products->products);
			}
		}
	}
}
