<?php

/*
*   Copyright (C) 2021  Sergey Tolkachyov
*   Released under GNU GPL Public License
*   License: http://www.gnu.org/copyleft/gpl.html
*   https://web-tolk.ru
*/

defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Plugin\CMSPlugin;
//use \Joomla\CMS\Factory;
//use \Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Table\Table;
use Joomla\CMS\Router\Route;
use Joomla\Registry\Registry;
class plgContentWt_jshopping_products_anywhere extends CMSPlugin
{

	static $article = null;

  public function __construct(&$subject, $params)
  {
    parent::__construct($subject, $params);
    // Load the language file
	  $this->loadLanguage();
  }

  public function onContentPrepare($context, $article, $params, $limitstart = 0)
	{

		if ($context == 'com_finder.indexer')
			{
				return true;
			}

		  //Проверка есть ли строка замены в контенте
			if(strpos($article->text, 'wt_jshop_products') === false)
			{
			  return;
			}
		
			$regex = '/{wt_jshop_products\s(.*?)}/i';
			preg_match_all($regex, $article->text, $settings_string);

		for($i = 0; $i <= count($settings_string); $i++){
					$short_code_params = array('product_id' => '',
					                           'tmpl'       => 'default',
								);

					$output_replace_pattern = $settings_string["0"][$i];
					$settings = $settings_string["1"][$i];
					$settings1 = explode(" ",$settings);
						foreach($settings1 as $param){
							$param = explode("=", $param);
							if (isset($short_code_params[$param[0]])) {
								$short_code_params[$param[0]] = $param[1];
							} else {
								$short_code_params[$param[0]] = "";
							}
						}



				if (!empty($short_code_params["product_id"]))
				{
					$product_id = $short_code_params["product_id"];
					$tmpl = $short_code_params["tmpl"];


					if (!file_exists(JPATH_SITE.'/components/com_jshopping/jshopping.php')){
						return;
					}

					require_once (JPATH_SITE.'/components/com_jshopping/lib/factory.php');
					require_once (JPATH_SITE.'/components/com_jshopping/lib/functions.php');
					JSFactory::loadLanguageFile();
					$jshopConfig = JSFactory::getConfig();
					$jshop_product = JSFactory::getTable('product', 'jshop');
					$jshop_product->load($product_id);


					if (!empty($jshop_product->product_id)){//существует ли товар с таким id
						$product = new Registry;
						$product->product_id = $jshop_product->product_id;
						$product->product_ean = $jshop_product->product_ean;
						$product->manufacturer_code = $jshop_product->manufacturer_code;
						$product->product_quantity = $jshop_product->product_quantity;
						$product->unlimited = $jshop_product->unlimited;
						$product->product_availability = $jshop_product->product_availability;
						$product->product_date_added = $jshop_product->product_date_added;
						$product->date_modify = $jshop_product->date_modify;
						$product->product_old_price = formatprice($jshop_product->product_old_price);
						$product->product_buy_price = formatprice($jshop_product->product_buy_price);
						$product->product_price = formatprice($jshop_product->product_price);
						$product->min_price = formatprice($jshop_product->min_price);
						$product->product_weight = $jshop_product->product_weight;
						$product->image = $jshopConfig->image_product_live_path . '/' . $jshop_product->image;
						$product->average_rating = $jshop_product->average_rating;
						$product->reviews_count = $jshop_product->reviews_count;
						$product->hits = $jshop_product->hits;

						$lang = JSFactory::getLang();
						$product_name = $lang->get('name');
						$product->name = $jshop_product->$product_name;

						$product_short_description = $lang->get('short_description');
						$product->short_description = $jshop_product->$product_short_description;

						$category_id = $jshop_product->getCategory();
						$defaultItemid = getDefaultItemid();
						$product->sef_link = Route::_('index.php?option=com_jshopping&&controller=product&task=view&category_id='.$category_id.'&product_id='.$product_id.'&Itemid='.$defaultItemid);

						ob_start();
						if(file_exists(JPATH_SITE . '/plugins/content/wt_jshopping_products_anywhere/tmpl/'. $tmpl.'.php')){
							require JPATH_SITE . '/plugins/content/wt_jshopping_products_anywhere/tmpl/' . $tmpl.'.php';
						} else {
							require JPATH_SITE . '/plugins/content/wt_jshopping_products_anywhere/tmpl/default.php';
						}

						$html = ob_get_clean();
					}else{
						//Товара с таким id не существует. Вставляем пустоту
						$html = '';
					}

					$article->text = str_replace($output_replace_pattern, $html, $article->text);
					unset($short_code_params);
				} else {
					return;
				}
		}//end FOR

	} //onContentPrepare END

}