jQuery(document).ready(function () {

	let wt_jshopping_compare_script_options = Joomla.getOptions('wt_jshopping_compare_script_options'); //количество видимых колонок на десктопе
	window.wtJshoppingCompareAllProductsCount = wt_jshopping_compare_script_options['countProducts'];//Общее количество товаров в сравнеии
	window.currentColsOffsetLeft = 0;
	window.currentColsOffsetRight = 0;

	setConsants(window.innerWidth);
	window.addEventListener("resize",function (){
		setConsants(window.innerWidth);
	});


	function setConsants(windowInnerWidth){

		if(windowInnerWidth > 767){
			window.columnWidth = 16.666667; //Bootstrap 4.6 - col-md-2 - 16.666667%
			window.visibleColumns = 6; //количество видимых колонок на десктопе
			console.log('window.innerWidth = ' + window.innerWidth);
			console.log('columnWidth = ' + window.visibleColumns);
			console.log('window.visibleColumns = ' + window.visibleColumns);
		} else {
			window.columnWidth = 100; //Bootstrap 4.6 - col-md-2 - 16.666667%
			window.visibleColumns = 1; //количество видимых колонок на мобиле
			console.log('window.innerWidth = ' + window.innerWidth);
			console.log('columnWidth = ' + window.visibleColumns);
			console.log('window.visibleColumns = ' + window.visibleColumns);
		}

	}


	/**
	 * Check if an element is in the visible viewport
	 * @param {jQuery|HTMLElement} el
	 * @return boolean
	 */
	let IsInViewportTop = function (el) {
		if (typeof jQuery === "function" && el instanceof jQuery) el = el[0];
		let rect = el.getBoundingClientRect();
		return (rect.top > 0);
	};

	jQuery(window).scroll(function () {
		//div за верхним краем экрана
		if (IsInViewportTop(jQuery('#comjshop')) === false) {

			jQuery('#hover-mini-products').addClass('position-fixed fixed-top').removeClass('d-none');
		} else {
			// здесь true - расстояние от div'а до края экрана - положительное значение
			jQuery('#hover-mini-products').removeClass('position-fixed').addClass('d-none');

		}
	})//window.scroll

	/**
	 * Очищаем сравнение товаров.
	 */
	jQuery('#wt-jshopping-compare-empty-list').click(function () {
		let data = encodeURIComponent("");

		document.cookie = "wtjshoppingcompare=" + data + ";max-age=0; path=/; domain=" + location.hostname;
		if ('body.wtjshoppingcompareView') {
			jQuery("#comjshop").empty();
			Joomla.Text.load({info: "Очищено"});
			let messages = {"info": ["Список товаров к сравнению очищен"]};
			Joomla.renderMessages(messages);

		}
		jQuery(".wt_jshop_compare_module .digit").html('').removeClass('active');

	});
	jQuery('#wt-jshopping-compare-collapse-toggle-all').click(function () {
		jQuery('.collapse').collapse('hide');
	})


	/**
	 * - считываем текущее смещение в колонках
	 * - прибавляем/вычитаем 1
	 * - умножаем коэффициент смещения на фикс.ширину колонки и получаем пикселы
	 * - смещаем
	 *
	 * @param cols
	 */

	if(window.innerWidth < 767){
		/**
		 * Сразу сдвигаем правую колонку на 1, чтобы сравнивать 1-й и 2-й товар.
		 */
		window.currentColsOffsetRight = -1;
		offsetCollumns(window.currentColsOffsetRight, 'right');
		let currentProductRight = getProductPager('right');

		jQuery('#hover-mini-products .compare-pager-right .compare-pager-count-products').html(currentProductRight);
	}





	/**
	 * Функция производит смещение ряда товаров и характеристик в левой и правой колонках.
	 * @params cols Количество колонок, на которое происходит смещение
	 * @params side Мобильный вид, с какой стороны происходит смещение - с левой или с правой
	*/

	function offsetCollumns(cols, side) {
		let offset = window.columnWidth * cols;
		console.log('offset ' + offset);
		jQuery('.compare-products-wrapper-' + side +' .compare-content').css('transform', 'translateX(' + offset + '%)');


	}

	jQuery('[data-compare]').click(function () {
		window.wtJshoppingCompareAllProductsCount = window.wtJshoppingCompareAllProductsCount - 1;
		jQuery('.compare-pager-total-products').html(window.wtJshoppingCompareAllProductsCount);
	});

	/**
	 * Работаем с кнопками только на десктопе
	 */

	if(window.innerWidth > 767){
//Прокрутка товаров вправо-влево - в десктопе и в мобильном виде - левая сторона
		jQuery('.compare-products-wrapper-left .btn-slide-products-left').click(function () {
			window.currentColsOffsetLeft = window.currentColsOffsetLeft + 1;
			offsetCollumns(window.currentColsOffsetLeft, 'left');

			if (window.currentColsOffsetLeft === 0) {//Если смещение 0 - первый товар виден в экране. Убираем кнопку "влево".
				jQuery('.compare-products-wrapper-left .btn-slide-products-left').hide();
			}

			if (window.currentColsOffsetLeft !== (window.visibleColumns - window.wtJshoppingCompareAllProductsCount)){
				jQuery('.compare-products-wrapper-left .btn-slide-products-right').show();
			}

			console.log('window.currentColsOffsetLeft ' + window.currentColsOffsetLeft);

		});
		jQuery('.compare-products-wrapper-left .btn-slide-products-right').click(function () {
			window.currentColsOffsetLeft = window.currentColsOffsetLeft - 1;
			offsetCollumns(window.currentColsOffsetLeft, 'left');
			if (window.currentColsOffsetLeft < 0) {//Если смещение меньше - 0 - первый товар НЕ виден в экране. Показываем кнопку "влево".
				jQuery('.compare-products-wrapper-left .btn-slide-products-left').show();
			}
			if (window.currentColsOffsetLeft === (visibleColumns - window.wtJshoppingCompareAllProductsCount)){
				jQuery('.compare-products-wrapper-left .btn-slide-products-right').hide();
			}
		});


		//Прокрутка товаров вправо-влево - в мобильном виде - правая сторона
		jQuery('.compare-products-wrapper-right .btn-slide-products-left').click(function () {
			window.currentColsOffsetRight = window.currentColsOffsetRight + 1;
			offsetCollumns(window.currentColsOffsetRight, 'right');

			if (window.currentColsOffsetRight === 0) {//Если смещение 0 - первый товар виден в экране. Убираем кнопку "влево".
				jQuery('.compare-products-wrapper-right .btn-slide-products-left').hide();
			}

			if (window.currentColsOffsetRight !== (window.visibleColumns - window.wtJshoppingCompareAllProductsCount)){
				jQuery('.compare-products-wrapper-right .btn-slide-products-right').show();
			}

			console.log('window.currentColsOffsetRight ' + window.currentColsOffsetRight);
			// jQuery('.compare-content').css('transform','translateX(-16.666667%)');
		})
		jQuery('.compare-products-wrapper-right .btn-slide-products-right').click(function () {
			window.currentColsOffsetRight = window.currentColsOffsetRight - 1;
			offsetCollumns(window.currentColsOffsetRight, 'right');
			if (window.currentColsOffsetRight < 0) {//Если смещение меньше - 0 - первый товар НЕ виден в экране. Показываем кнопку "влево".
				jQuery('.compare-products-wrapper-right .btn-slide-products-left').show();
			}
			if (window.currentColsOffsetRight === (visibleColumns - window.wtJshoppingCompareAllProductsCount)){
				jQuery('.compare-products-wrapper-right .btn-slide-products-right').hide();
			}

			console.log('window.currentColsOffsetRight ' + window.currentColsOffsetRight);
			// jQuery('.compare-content').css('transform','translateX(16.666667%)');
		});

	}


	//Чувствительность — количество пикселей, после которого жест будет считаться свайпом
	const sensitivity = 20;
	let touchStart = null; //Точка начала касания
	let touchPosition = null; //Текущая позиция
	const compareProductsWrapperLeft = document.getElementsByClassName('compare-products-wrapper-left');
	const compareProductsWrapperRight = document.getElementsByClassName('compare-products-wrapper-right');

	jQuery.each(compareProductsWrapperLeft, function(){

		//Перехватываем события
		this.addEventListener("touchstart", function (e) { TouchStart(e); }); //Начало касания
		this.addEventListener("touchmove", function (e) { TouchMove(e); }); //Движение пальцем по экрану
//Пользователь отпустил экран
		this.addEventListener("touchend", function (e) { TouchEnd(e, "left"); });
//Отмена касания
		this.addEventListener("touchcancel", function (e) { TouchEnd(e, "left"); });
	});
	jQuery.each(compareProductsWrapperRight, function(){

		//Перехватываем события
		this.addEventListener("touchstart", function (e) { TouchStart(e); }); //Начало касания
		this.addEventListener("touchmove", function (e) { TouchMove(e); }); //Движение пальцем по экрану
//Пользователь отпустил экран
		this.addEventListener("touchend", function (e) { TouchEnd(e, "right"); });
//Отмена касания
		this.addEventListener("touchcancel", function (e) { TouchEnd(e, "right"); });
	});



	function TouchStart(e)
	{
		//Получаем текущую позицию касания
		touchStart = { x: e.changedTouches[0].clientX, y: e.changedTouches[0].clientY };
		touchPosition = { x: touchStart.x, y: touchStart.y };
	}

	function TouchMove(e)
	{
		//Получаем новую позицию
		touchPosition = { x: e.changedTouches[0].clientX, y: e.changedTouches[0].clientY };
	}

	function TouchEnd(e, side)
	{
		let direction = CheckAction(); //Определяем, какой жест совершил пользователь

		if (side === "left"){
			if(direction === 'toRight' && window.currentColsOffsetLeft !== 0){ //Пользователь двигал пальцем слева направо
				window.currentColsOffsetLeft = window.currentColsOffsetLeft + 1;
				offsetCollumns(window.currentColsOffsetLeft, 'left');
				let currentProductLeft = getProductPager('left');
				jQuery('#hover-mini-products .compare-pager-left .compare-pager-count-products').html(currentProductLeft);
			}
			if(direction === 'toLeft' && window.currentColsOffsetLeft !== (window.visibleColumns - window.wtJshoppingCompareAllProductsCount)){//Пользователь двигал пальцем справа налево

				window.currentColsOffsetLeft = window.currentColsOffsetLeft - 1;
				offsetCollumns(window.currentColsOffsetLeft, 'left');
				let currentProductLeft = getProductPager('left');
				jQuery('#hover-mini-products .compare-pager-left .compare-pager-count-products').html(currentProductLeft);
			}
		}


		if (side === "right"){
			if(direction === 'toRight' && window.currentColsOffsetRight !== 0){ //Пользователь двигал пальцем слева направо

				window.currentColsOffsetRight = window.currentColsOffsetRight + 1;
				offsetCollumns(window.currentColsOffsetRight, 'right');
				let currentProductRight = getProductPager('right');
				jQuery('#hover-mini-products .compare-pager-right .compare-pager-count-products').html(currentProductRight);

			}
			if(direction === 'toLeft' && window.currentColsOffsetRight !== (window.visibleColumns - window.wtJshoppingCompareAllProductsCount)){//Пользователь двигал пальцем справа налево

				window.currentColsOffsetRight = window.currentColsOffsetRight - 1;
				offsetCollumns(window.currentColsOffsetRight, 'right');
				let currentProductRight = getProductPager('right');
				jQuery('#hover-mini-products .compare-pager-right .compare-pager-count-products').html(currentProductRight);
			}
		}

		//Очищаем позиции
		touchStart = null;
		touchPosition = null;
	}

	function CheckAction()
	{
		let d = //Получаем расстояния от начальной до конечной точек по обеим осям
			{
				x: touchStart.x - touchPosition.x,
				y: touchStart.y - touchPosition.y
			};

		if(Math.abs(d.x) > Math.abs(d.y)) //Проверяем, движение по какой оси было длиннее
		{
			if(Math.abs(d.x) > sensitivity) //Проверяем, было ли движение достаточно длинным
			{
				if(d.x > 0) //Если значение больше нуля, значит пользователь двигал пальцем справа налево
				{
					return "toLeft";
				}
				else //Иначе он двигал им слева направо
				{
					return "toRight";
				}
			}
		}
	}

	function getProductPager(side){
		if(side == 'left'){
			return window.wtJshoppingCompareAllProductsCount - (window.wtJshoppingCompareAllProductsCount + window.currentColsOffsetLeft) + 1;
		}
		if(side == 'right'){
			return window.wtJshoppingCompareAllProductsCount - (window.wtJshoppingCompareAllProductsCount + window.currentColsOffsetRight) + 1;
		}


	}

});