<?php
/**
 * @package    WT JoomShopping last seen products
 * @author     Sergey Tolkachyov, info@web-tolk.ru https://web-tolk.ru
 * @copyright  Copyright (C) 2021 Sergey Tolkachyov. All rights reserved.
 * @license    GNU General Public License version 3 or later
 */

defined('_JEXEC') or die;
use Joomla\CMS\Factory;
use Joomla\CMS\Helper\ModuleHelper;
use Joomla\CMS\Plugin\PluginHelper;

if (!file_exists(JPATH_SITE . '/components/com_jshopping/jshopping.php'))
{
	throw new Exception('Please install JoomShopping', 500);
}

if(PluginHelper::isEnabled('jshoppingproducts','wt_jshopping_last_seen_products') == false){
	$app = Factory::getApplication();
	$app->enqueueMessage('<h5>WT Jshopping last seen products module</h5><p>Please, enable WT Jshopping last seen products plugin for module work.</p>','warning');
	return ;
}
require_once(JPATH_SITE . '/components/com_jshopping/lib/factory.php');
require_once(JPATH_SITE . '/components/com_jshopping/lib/functions.php');
require_once __DIR__ . '/helper.php';

$jshopConfig = JSFactory::getConfig();

$products        = ModWtJshoppingLastSeenProducts::getLastSeenProducts($params);
$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));

require ModuleHelper::getLayoutPath('mod_wt_jshopping_last_seen_products', $params->get('layout', 'default'));
