<?php
/**
 * @version      4.16.4 05.10.2017
 * @author       MAXXmarketing GmbH
 * @package      Jshopping
 * @copyright    Copyright (C) 2010 webdesigner-profi.de. All rights reserved.
 * @license      GNU/GPL
 */
defined('_JEXEC') or die();
$countprod = count($this->products);
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Factory;

$doc = Factory::getDocument();

?>
<script>
	jQuery(document).ready(function ($) {
		$('.btn-change-qty').click(function(){
			document.updateCart.submit();
		});
		$('form[name=updateCart] input[name*=quantity]').change(function(){
			document.updateCart.submit();

		});
	});
</script>
<div class="jshop" id="comjshop">
<?php print $this->checkout_navigator?>

	<h1><?php echo $doc->getTitle();?></h1>

	<?php if ($countprod > 0) :?>
			<div class="row">
				<div class="col-12 col-lg-9">
					<form action="<?php print SEFLink('index.php?option=com_jshopping&controller=cart&task=refresh') ?>" method="post" name="updateCart">
						<?php print $this->_tmp_ext_html_cart_start ?>

						<?php
							foreach ($this->products as $key_id => $prod){
								echo $prod['_tmp_tr_before'];
								?>

								<div class="row jshop_prod_cart shadow-sm p-3 mb-2 shadow-hover">

									<?php if ($prod['not_delete']) { ?>
										<?php echo $prod['not_delete_html'] ? $prod['not_delete_html'] : '-'; ?>
									<?php } else { ?>
										<div class="col-12 d-flex justify-content-end order-1">
											<a class="btn btn-sm text-secondary cart-remove-product-btn" href="<?php print $prod['href_delete']?>" title="<?php print _JSHOP_DELETE?>" onclick="return confirm('<?php print _JSHOP_CONFIRM_REMOVE?>')">
												<i class="fas fa-times"></i>
											</a>
										</div>
									<?php } ?>


									<div class="col-4 col-sm-2 col-md-2 col-lg-2 col-xl-2 data order-2">
										<?php echo $prod['_tmp_img_before']; ?>
										<a href="<?php print $prod['href'] ?>">
											<?php
											/*
											 * file src
											 * alt
											 * attrs
											 * relative to 'media' folder
											 * returnPath
											 * see HTMLHelper class for more info in comments
											 */
											echo HTMLHelper::image($this->image_product_path.'/'.($prod['thumb_image'] ? $prod['thumb_image'] : $this->no_image), htmlspecialchars($prod['product_name']),'class="jshop_img img-fluid" loading="lazy" width="'.$this->config->image_product_width.'" height="'.$this->config->image_product_height.'"',0);
											?>
										</a>
										<?php echo $prod['_tmp_img_after']; ?>
									</div>
									<div class="col-8 col-sm col-md col-lg-5 col-xl-5 d-flex flex-column data order-3">
										<?php if ($this->config->show_product_code_in_cart) { ?>
											<small class="jshop_code_prod"><?php print _JSHOP_EAN?>: <?php print $prod['ean'] ?></small>
										<?php } ?>
										<a href="<?php print $prod['href'] ?>" class="h5">
											<?php print $prod['product_name'] ?>
										</a>

										<?php print $prod['_ext_product_name'] ?>
										<?php if ($prod['manufacturer'] != '') { ?>
											<small class="manufacturer"><?php print _JSHOP_MANUFACTURER ?>: <span><?php print $prod['manufacturer'] ?></span></small>
										<?php } ?>
										<?php if ($this->config->manufacturer_code_in_cart && $prod['manufacturer_code']){?>
											<small class="manufacturer_code"><?php print _JSHOP_MANUFACTURER_CODE ?>: <span><?php print $prod['manufacturer_code'] ?></span></small>
										<?php }?>
										<?php print sprintAtributeInCart($prod['attributes_value']); ?>
										<?php print sprintFreeAtributeInCart($prod['free_attributes_value']); ?>
										<?php print sprintFreeExtraFiledsInCart($prod['extra_fields']); ?>
										<?php print $prod['_ext_attribute_html'] ?>
										<?php if ($this->config->show_delivery_time_step5 && $prod['delivery_times_id']){?>
											<div class="deliverytime">
												<?php print _JSHOP_DELIVERY_TIME?>:
												<?php print $this->deliverytimes[$prod['delivery_times_id']]?>
											</div>
										<?php }?>

									</div>
									<div class="col-6 col-sm-3 col-md-2 col-lg-3 data d-flex flex-column justify-content-center order-5 order-lg-5">
										<?php print $prod['_ext_price_html'] ?>
										<span class="product_price_total h5 text-center"><?php print formatprice($prod['price'] * $prod['quantity']); ?></span>
										<?php if ($this->config->show_tax_product_in_cart && $prod['tax'] > 0) { ?>
											<span class="taxinfo"><?php print productTaxInfo($prod['tax']); ?></span>
										<?php } ?>
										<?php if ($this->config->cart_basic_price_show && $prod['basicprice'] > 0) { ?>
											<div class="basic_price">
												<?php print _JSHOP_BASIC_PRICE ?>:
												<span><?php print sprintBasicPrice($prod); ?></span>
											</div>
										<?php } ?>

										<?php if($prod['quantity'] > 1):?>
											<small class="product_price text-muted text-center"><?php echo $prod['quantity'];?> &times; <?php print formatprice($prod['price']); ?> </small>
											<?php print $prod['_ext_price_total_html'] ?>
											<?php if ($this->config->show_tax_product_in_cart && $prod['tax'] > 0) { ?>
												<span class="taxinfo"><?php print productTaxInfo($prod['tax']); ?></span>
											<?php } ?>
										<?php endif;?>

									</div>
									<div class="col-4 col-sm-2 col-md-2 col-lg-2 p-0 data d-flex align-items-center justify-content-center order-4 order-lg-4">
											<?php if ($prod['not_qty_update']){?>
												<span class="qtyval"><?php print $prod['quantity'] ?></span>
											<?php }else{   //onclick="document.updateCart.submit();"?>
													<button type="button" class="btn-change-qty btn btn-sm" onclick="this.parentNode.querySelector('input[type=number]').stepDown()" >−</button>
													<input type="number" min="1" name="quantity[<?php print $key_id ?>]" value="<?php print $prod['quantity'] ?>" class="form-control form-control-sm cart-product-qty" />
													<button type="button" class="btn-change-qty btn btn-sm" onclick="this.parentNode.querySelector('input[type=number]').stepUp()" >+</button>
											<?php }?>
											<?php print $prod['_qty_unit']; ?>
											<?php /*if (!$prod['not_qty_update']){?>
												<button class="btn btn-sm btn-secondary" title="<?php print _JSHOP_UPDATE_CART; ?>" onclick="document.updateCart.submit();"><i class="fas fa-sync-alt"></i></button>

											<?php }*/?>

									</div>
								</div>



								<?php
								echo $prod['_tmp_tr_after'];
							}
							?>

					</form>
				</div>
				<div class="col-12 col-lg-3 border border-light mt-3 mt-lg-0 pt-2">
					<h3 class="text-center"><?php echo _JSHOP_CART;?></h3>
					<p class="text-center">Товаров в корзине <?php print $countprod;?></p>

					<?php if ($this->config->show_weight_order) : ?>
						<div class = "weightorder">
							<?php print _JSHOP_WEIGHT_PRODUCTS?>: <span><?php print formatweight($this->weight);?></span>
						</div>
					<?php endif; ?>

					<?php if ($this->config->summ_null_shipping > 0) : ?>
						<div class = "shippingfree text-center mb-3">
							<i class="far fa-check-circle text-success"></i> <?php printf(_JSHOP_FROM_PRICE_SHIPPING_FREE, formatprice($this->config->summ_null_shipping, null, 1));?>
						</div>
					<?php endif; ?>

					<?php if (!$this->hide_subtotal){?>
						<div class="subtotal">
							<span class="h5 mr-2 name"><?php print _JSHOP_SUBTOTAL; ?></span>
							<span class="h5 font-weight-bolder value"><?php print formatprice($this->summ);?><?php print $this->_tmp_ext_subtotal;?></span>
						</div>
					<?php } ?>

					<?php print $this->_tmp_html_after_subtotal;?>

					<?php if ($this->discount > 0){ ?>
						<div class="col text-right discount">
							<span class="h5 mr-2 name"> <?php print _JSHOP_RABATT_VALUE ?><?php print $this->_tmp_ext_discount_text?></span>
							<span class="h5 font-weight-bolder value"><?php print formatprice(-$this->discount);?><?php print $this->_tmp_ext_discount?></span>
						</div>
					<?php } ?>

					<?php if (!$this->config->hide_tax){?>

						<?php foreach($this->tax_list as $percent=>$value){ ?>
							<div class="col text-right tax">
								<span class="h5 mr-2 name">
									<?php print displayTotalCartTaxName();?>
									<?php if ($this->show_percent_tax) print formattax($percent)."%"?>
								</span>
								<span class="h5 font-weight-bolder value">
									<?php print formatprice($value);?><?php print $this->_tmp_ext_tax[$percent]?>
								</span>
							</div>
						<?php } ?>
					<?php } ?>




					<div class="col text-center total">
						<?php /*?>
						<span class="h5 mr-2 name"> <?php print _JSHOP_PRICE_TOTAL; ?></span>
 						<?php */?>
						<span class="h3 font-weight-bolder value"><?php print formatprice($this->fullsumm);?><?php print $this->_tmp_ext_total;?></span>
					</div>
					<?php print $this->_tmp_html_after_total?>


					<?php if ($this->config->show_plus_shipping_in_product){?>
						<div class="col text-right plusshipping">
							<span class="text-muted plusshippinginfo"> <?php print sprintf(_JSHOP_PLUS_SHIPPING, $this->shippinginfo);?></span>
						</div>
					<?php } ?>

					<?php if ($this->free_discount > 0){?>
						<div class="free_discount text-center">
							<span class="free_discount_info font-weight-bold"><?php print _JSHOP_FREE_DISCOUNT;?>: <?php print formatprice($this->free_discount); ?></span>
						</div>
					<?php } ?>


					<?php // ПРОМОКОДЫ ?>
					<?php print $this->_tmp_ext_html_before_discount?>

					<?php if ($this->use_rabatt && $countprod>0) : ?>

						<div class="cart_block_discount mt-4">
							<form name="rabatt" method="post" action="<?php print SEFLink('index.php?option=com_jshopping&controller=cart&task=discountsave'); ?>">
								<label for="rabatt" class="mb-1"><?php print _JSHOP_RABATT ?></label>
								<div class = "input-group">
									<input type="text" class="form-control form-control-sm" name="rabatt" id="rabatt" value="" />
									<div class="input-group-append">
										<button type="submit" class="button btn btn-sm btn-outline-dark"><?php print _JSHOP_RABATT_ACTIVE ?></button>
									</div>
								</div>
							</form>
						</div>
					<?php endif; ?>

					<?php // КНОПКА ОФОРМИТЬ ЗАКАЗ  ?>
					<?php if ($countprod>0) : ?>
					<div class="buttons">
						<?php print $this->_tmp_html_before_buttons?>

						<div id = "checkout" class="d-flex">
							<a href = "<?php print $this->href_checkout ?>" class="btn btn-mz-blue mt-3 mx-auto">
								<?php print _JSHOP_CHECKOUT ?>
							</a>
						</div>

						<?php
						if ($this->config->show_cart_clear){?>
							<div class="clear-cart d-flex">
								<a class="btn clear-cart btn-outline-dark mx-auto" href="<?php print SEFLink('index.php?option=com_jshopping&controller=cart&task=clear')?>" onclick="return confirm('<?php print _JSHOP_CONFIRM_REMOVE_ALL?>')">
									<?php print _JSHOP_CLEAR_CART?>
								</a>
							</div>
						<?php }?>

						<?php print $this->_tmp_html_after_buttons?>
					</div>
					<?php endif; ?>
					<?php if (!empty($this->cartdescr)):?>
						<div class = "cartdescr text-dark p-3"><?php print $this->cartdescr; ?></div>
					<?php endif;?>

				</div>
			</div>
	<?php else : //ЕСЛИ В КОРЗИНЕ НЕТ ТОВАРОВ ?>
		<div class="alert alert-danger cart_empty_text"><h4><?php print _JSHOP_CART_EMPTY;?></h4></div>
	<?php endif; ?>

	<div class = "jshop cart_buttons d-flex">
		<a href = "<?php print $this->href_shop ?>" class="btn btn-outline-primary mr-auto">
			<i class="fas fa-chevron-left"></i>  <?php print _JSHOP_BACK_TO_SHOP ?>
		</a>
	</div>




</div>