<?php
/**
 * @package     WT SEO Meta Templates - Content
 * @version     1.2.0
 * @Author Sergey Tolkachyov, https://web-tolk.ru
 * @copyright   Copyright (C) 2022 Sergey Tolkachyov
 * @license     GNU/GPL http://www.gnu.org/licenses/gpl-2.0.html
 * @since       1.0
 */
// No direct access
defined( '_JEXEC' ) or die;
use Joomla\CMS\Application\CMSApplication;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Plugin\PluginHelper;
use \Joomla\CMS\MVC\Model\BaseDatabaseModel;
use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Profiler\Profiler;
class plgSystemWt_seo_meta_templates_content extends CMSPlugin
{
	public function __construct( &$subject, $config )
	{

		parent::__construct( $subject, $config );
		$this->loadLanguage();
	}

	public function onWt_seo_meta_templatesAddVariables(){
		!JDEBUG ?: Profiler::getInstance('Application')->mark('<strong>plg WT SEO Meta templates - com_content provider plugin</strong>: start');
		$app = Factory::getApplication();
		$option = $app->input->get('option');
		$id = $app->input->get('id');

		if($option == 'com_content'){
			BaseDatabaseModel::addIncludePath(JPATH_SITE . '/components/com_content/models/', 'ContentModel');
			JLoader::register('FieldsHelper', JPATH_ADMINISTRATOR . '/components/com_fields/helpers/fields.php');
			!JDEBUG ?: Profiler::getInstance('Application')->mark('<strong>plg WT SEO Meta templates - com_content provider plugin</strong>: After load Field helper');
			$variables = array();
			//Массив для тайтлов и дескрипшнов по формуле для передачи в основной плагин
			$seo_meta_template = array();
			// Short codes for com_content category view
			if($app->input->get('view') == 'category'){

			!JDEBUG ?: Profiler::getInstance('Application')->mark('<strong>plg WT SEO Meta templates - com_content provider plugin</strong>: Before load Content category');
							$model = BaseDatabaseModel::getInstance('Category', 'ContentModel');
							$category = $model->getCategory();
							$category->jcfields = FieldsHelper::getFields("com_content.categories",$category, true);

			!JDEBUG ?: Profiler::getInstance('Application')->mark('<strong>plg WT SEO Meta templates - com_content provider plugin</strong>: After load Content category');

				/*
				 * Com_content category variables for short codes
				 */
				//Com_content category name
				$variables[] = [
						'variable' => 'CC_CATEGORY_TITLE',
						'value'    => $category->title,
					];
				//Com_content category id
				$variables[] = [
						'variable' => 'CC_CATEGORY_ID',
						'value'    => $category->id,
					];

				//Com_content parent category title
				$parent_category = $category->get('_parent');
				$variables[] = [
					'variable' => 'CC_PARENT_CATEGORY_TITLE',
					'value'    => $parent_category->title,
				];

				foreach ($category->jcfields as $field){
					// com_content article custom field title
					$variables[] = [
						'variable' => 'CC_CATEGORY_FIELD_'.$field->id.'_TITLE',
						'value'    => $field->title,
					];

					// com_content article custom field value
					$variables[] = [
						'variable' => 'CC_CATEGORY_FIELD_'.$field->id.'_VALUE',
						'value'    => $field->value,
					];

					// com_content article custom field title and value merged
					$variables[] = [
						'variable' => 'CC_CATEGORY_FIELD_'.$field->id,
						'value'    => $field->title.' '.$field->value,
					];

				}


				/*
				 * Если включена глобальная перезапись <title> категории. Все по формуле.
				 */
				if($this->params->get('show_debug') == 1){
					echo '<h4>WT SEO Meta templates - com_content provider plugin debug</h4>';
					echo '<p><strong>Com_content Title</strong>: '.$category->title.'</p>';
					echo '<p><strong>Com_content Meta desc:</strong> '.$category->description.'</p>';
				}

				$category_title_category_exclude = $this->params->get('cc_category_title_category_exclude');
				if(!is_array($category_title_category_exclude)){
					$category_title_category_exclude = array();
				}

				if($this->params->get('global_cc_category_title_replace') == 1 && !in_array($category->id,$category_title_category_exclude)){

					// Переписываем все title категорий глобально
					// У категорий нет отдельного поля для title
						if($this->params->get('show_debug') == 1)
						{
							echo Text::_('PLG_WT_SEO_META_TEMPLATES_CONTENT_DEBUG_GLOBAL_CATEGORY_TITLE_REPLACE');
						}
						$title_template = $this->params->get('content_category_title_template');
						if(!empty($title_template)){
							$seo_meta_template['title'] = $title_template;
						}
				}
				/*
				 * Если включена глобальная перезапись description категории. Все по формуле.
				 */

				$category_metadesc_category_exclude = $this->params->get('cc_category_metadesc_category_exclude');
				if(!is_array($category_metadesc_category_exclude)){
					$category_metadesc_category_exclude = array();
				}
				if($this->params->get('global_cc_category_description_replace') == 1 && !in_array($category->id,$category_metadesc_category_exclude)){

					/*
					 * Если переписываем только пустые. Там, где пустое
					 * $category->metadesc
					 */

					if($this->params->get('global_cc_category_description_replace_only_empty') == 1){
						if($this->params->get('show_debug') == 1)
						{
							echo Text::_('PLG_WT_SEO_META_TEMPLATES_CONTENT_DEBUG_GLOBAL_CATEGORY_META_DESCRIPTION_REPLACE_ONLY_EMPTY');
						}

						if(empty($category->metadesc) == true){
							if($this->params->get('show_debug') == 1)
							{
								echo Text::_('PLG_WT_SEO_META_TEMPLATES_CONTENT_DEBUG_EMPTY_META_DESCRIPTION_FOUND');
							}
							$description_template = $this->params->get('content_category_meta_description_template');

							if(!empty($description_template)){
								$seo_meta_template['description'] = $description_template;
							}

						}
					}else{
						//Переписываем все meta description категорий глобально
						if($this->params->get('show_debug') == 1)
						{
							echo Text::_('PLG_WT_SEO_META_TEMPLATES_CONTENT_DEBUG_GLOBAL_CATEGORY_META_DESCRIPTION_REPLACE');
						}
						$description_template = $this->params->get('content_category_meta_description_template');
						if(!empty($description_template)){
							$seo_meta_template['description'] = $description_template;
						}
					}
				}
			}
			// Short codes for com_content articles view
			elseif ($app->input->get('view') == 'article'){

				!JDEBUG ?: Profiler::getInstance('Application')->mark('<strong>plg WT SEO Meta templates - com_content provider plugin</strong>: Before load article');

							$model = BaseDatabaseModel::getInstance('Article', 'ContentModel');
							$article = $model->getItem($id);
							$article->jcfields = FieldsHelper::getFields("com_content.article",$article, true);

				!JDEBUG ?: Profiler::getInstance('Application')->mark('<strong>plg WT SEO Meta templates - com_content provider plugin</strong>: After load article');

				/*
				 * Com_content article variables for short codes
				 */
				//Article id
				$variables[] = [
					'variable' => 'CC_ARTICLE_ID',
					'value'    => $article->id,
				];
				//Article title
				$variables[] = [
					'variable' => 'CC_ARTICLE_TITLE',
					'value'    => $article->title,
				];
				//Article hits
				$variables[] = [
					'variable' => 'CC_ARTICLE_HITS',
					'value'    => $article->hits,
				];

				//Article's parent category title
				$variables[] = [
					'variable' => 'CC_ARTICLE_CATEGORY_TITLE',
					'value'    => $article->category_title,
				];

				//Article author
				$variables[] = [
					'variable' => 'CC_ARTICLE_AUTHOR',
					'value'    => $article->author,
				];

				//Article intro text
				if (!empty($article->introtext)){
					(int) $intro_text_max_lenght = $this->params->get('cc_article_intro_text_max_chars',200);

					$article_intro_text = trim(strip_tags(html_entity_decode($article->introtext, ENT_QUOTES, 'UTF-8')));
					$article_intro_text = str_replace(array("\r\n", "\r", "\n", "\t", '  ', '   '), ' ', $article_intro_text);
					if($intro_text_max_lenght > 3){
						$intro_text_max_lenght = $intro_text_max_lenght - 3; // For '...' in the end of string
					}
					$article_intro_text = mb_substr($article_intro_text, 0, $intro_text_max_lenght, 'utf-8');
					$article_intro_text = $article_intro_text.'...';

				} else {
					$article_intro_text = '';
				}


				$variables[] = [
					'variable' => 'CC_ARTICLE_INTRO',
					'value'    => $article_intro_text,
				];

				foreach ($article->jcfields as $field){
					// com_content article custom field title
					$variables[] = [
						'variable' => 'CC_ARTICLE_FIELD_'.$field->id.'_TITLE',
						'value'    => $field->title,
					];

					// com_content article custom field value
					$variables[] = [
						'variable' => 'CC_ARTICLE_FIELD_'.$field->id.'_VALUE',
						'value'    => $field->value,
					];

					// com_content article custom field title and value merged
					$variables[] = [
						'variable' => 'CC_ARTICLE_FIELD_'.$field->id,
						'value'    => $field->title.' '.$field->value,
					];

				}

				$article_title_category_exclude = $this->params->get('cc_article_title_category_exclude');
				if(!is_array($article_title_category_exclude)){
					$article_title_category_exclude = array();
				}
				$article_metadesc_category_exclude = $this->params->get('cc_article_metadesc_category_exclude');
				if(!is_array($article_metadesc_category_exclude)){
					$article_metadesc_category_exclude = array();
				}
				if($this->params->get('global_article_title_replace') == 1 && !in_array($article->catid,$article_title_category_exclude)){

						/*
						 * Если переписываем только пустые. Там, где пустое
						 * $article->params->get('article_page_title')
						 */

						if($this->params->get('global_article_title_replace_only_empty') == 1){
							if($this->params->get('show_debug') == 1)
							{
								echo Text::_('PLG_WT_SEO_META_TEMPLATES_CONTENT_DEBUG_GLOBAL_ARTICLE_TITLE_REPLACE_ONLY_EMPTY');
							}

							if(empty($article->params->get('article_page_title')) == true){
								if($this->params->get('show_debug') == 1)
								{
									echo Text::_('PLG_WT_SEO_META_TEMPLATES_CONTENT_DEBUG_EMPTY_ARTICLE_TITLE_FOUND');
								}
								$title_template = $this->params->get('content_article_title_template');
								if(!empty($title_template)){
									$seo_meta_template['title'] = $title_template;
								}
							}
						}else{
							//Переписываем все глобально
							if($this->params->get('show_debug') == 1)
							{
								echo Text::_('PLG_WT_SEO_META_TEMPLATES_CONTENT_DEBUG_GLOBAL_ARTICLE_TITLE_REPLACE');
							}
							$title_template = $this->params->get('content_article_title_template');
							if(!empty($title_template)){
								$seo_meta_template['title'] = $title_template;
							}
						}
					}

					/*
					 * Если включена глобальная перезапись description материала. Все по формуле.
					 */

					if($this->params->get('global_article_meta_description_replace') == 1 && !in_array($article->catid,$article_metadesc_category_exclude)){

						/*
						 * Если переписываем только пустые. Там, где пустое
						 * $article->description
						 */

						if($this->params->get('global_article_meta_description_replace_only_empty') == 1){
							if($this->params->get('show_debug') == 1)
							{
								echo Text::_('PLG_WT_SEO_META_TEMPLATES_CONTENT_DEBUG_GLOBAL_ARTICLE_META_DESCRIPTION_REPLACE_ONLY_EMPTY');
							}
							if(empty($article->metadesc) == true){
								if($this->params->get('show_debug') == 1)
								{
									echo Text::_('PLG_WT_SEO_META_TEMPLATES_CONTENT_DEBUG_EMPTY_ARTICLE_META_DESCRIPTION_FOUND');
								}
								$description_template = $this->params->get('content_article_meta_description_template');
								if(!empty($description_template)){
									$seo_meta_template['description'] = $description_template;
								}
							}
						}else{
							//Переписываем все глобально
							if($this->params->get('show_debug') == 1)
							{
								echo Text::_('PLG_WT_SEO_META_TEMPLATES_CONTENT_DEBUG_GLOBAL_ARTICLE_TITLE_REPLACE');
							}
							$description_template = $this->params->get('content_article_meta_description_template');
							if(!empty($description_template)){
								$seo_meta_template['description'] = $description_template;
							}
						}
					}


			}//elseif ($app->input->get('view') == 'article')


			$data = array(
				'variables' => $variables,
				'seo_tags_templates' => $seo_meta_template,
			);


			if($this->params->get('show_debug') == 1)
			{
				echo '<h4>$data array sends to WT SEO Meta templates plugin</h4><pre>';
				print_r($data);
				echo '</pre>';
			}
			!JDEBUG ?: Profiler::getInstance('Application')->mark('<strong>plg WT SEO Meta templates - com_content provider plugin</strong>: Before return data. End.');
			return $data;
		}//if($option == 'com_content')
	}

}//plgSystemWt_seo_meta_templates_content