<?php
/**
 * @package       Blank page
 * @version       2.0.1
 * @Author        Sergey Tolkachyov
 * @copyright     Copyright (c) 2018 - 2025 Sergey Tolkachyov. All rights reserved.
 * @license       GNU/GPL3 http://www.gnu.org/licenses/gpl-3.0.html
 * @link       https://web-tolk.ru/dev/components/blank-page-component-for-joomla
 * @since         1.0.0
 */
namespace Joomla\Component\Blank\Site\View\Blank;

use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Factory;
use Joomla\CMS\MVC\View\HtmlView as BaseHtmlView;
use Joomla\CMS\Application\SiteApplication;
use function defined;

defined('_JEXEC') or die;


/**
 * Blan page view.
 *
 * @since  1.0.0
 */
class HtmlView extends BaseHtmlView
{
	/**
	 * Execute and display a template script.
	 *
	 * @param   string  $tpl  The name of the template file to parse; automatically searches through the template paths.
	 *
	 * @return  void
	 */
	public function display($tpl = null) : void
	{
		$params           = ComponentHelper::getParams('com_blank');
		$menuActiveParams = Factory::getContainer()->get(SiteApplication::class)->getMenu('site')->getActive()->getParams();

		$titleSource = (bool) $params->get('titlesource', 0);
		$descSource  = (bool) $params->get('descsource', 0);

		$jConfig = Factory::getContainer()->get('config');
		$doc = Factory::getApplication()->getDocument();
		if ($titleSource)
		{
			$pageTitle = $jConfig->get('sitename');
		}
		else
		{
			$pageTitle = $menuActiveParams->get('page_title', $jConfig->get('sitename'));
		}

		if ($descSource)
		{
			$pageDesc = $doc->description;
		}
		else
		{
			$pageDesc = $menuActiveParams->get('menu-meta_description', $doc->description);
		}

		$doc->setTitle($pageTitle);
		if ($pageDesc)
		{
			$doc->setMetaData('description', $pageDesc);
		}

		parent::display($tpl);
	}

}
