<?php
/**
 *  @package   Jshopping_order_products_by_availability
 *  @copyright Copyright Sergey Tolkachyov, 2022
 *  @license   GNU General Public License version 3, or later
 */

defined('_JEXEC') || die;

use Joomla\CMS\Extension\PluginInterface;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\DI\Container;
use Joomla\DI\ServiceProviderInterface;
use Joomla\Event\DispatcherInterface;
use Joomla\Plugin\Jshoppingproducts\Jshopping_order_products_by_availability\Extension\Jshopping_order_products_by_availability;


return new class implements ServiceProviderInterface {
	/**
	 * Registers the service provider with a DI container.
	 *
	 * @param   Container  $container  The DI container.
	 *
	 * @return  void
	 *
	 * @since   4.0.0
	 */
	public function register(Container $container)
	{
		$container->set(
			PluginInterface::class,
			function (Container $container) {
				$subject = $container->get(DispatcherInterface::class);
				$config  = (array) PluginHelper::getPlugin('jshoppingproducts', 'jshopping_order_products_by_availability');
				return new Jshopping_order_products_by_availability($subject, $config);
			}
		);
	}
};