<?php 
/**
* @version      4.9.1 13.08.2013
* @author       MAXXmarketing GmbH
* @package      Jshopping
* @copyright    Copyright (C) 2010 webdesigner-profi.de. All rights reserved.
* @license      GNU/GPL
*/
defined('_JEXEC') or die('Restricted access');

?>
<?php

if ($this->params->get('show_page_heading') && $this->params->get('page_heading')) : ?>
    <div class="shophead<?php print $this->params->get('pageclass_sfx');?>">
        <h1><?php print $this->params->get('page_heading')?></h1>
    </div>
<?php endif; ?>

<div class="jshop" id="comjshop">

    <div class="manufacturer_description">
        <?php print $this->manufacturer->description?>
    </div>

    <?php if (count($this->rows)) : ?>
    <div class="jshop_list_manufacturer">
        <div class = "jshop row row-cols-1 row-cols-md-<?php echo $this->count_manufacturer_to_row;?>">
            <?php foreach($this->rows as $k=>$row) : ?>
				<div class = "jshop_categ manufacturer col m-0 p-0">
					<div class="card h-100">
						<div class="row no-gutters">
							<div class="col-4 d-flex flex-column justify-content-start align-items-center">
								<a href = "<?php print $row->link;?>">
									<img class = "jshop_img card-img-top" src = "<?php print $this->image_manufs_live_path;?>/<?php if ($row->manufacturer_logo) print $row->manufacturer_logo; else print $this->noimage;?>" alt="<?php print htmlspecialchars($row->name);?>" />
								</a>
							</div>
							<div class="col-8">
								<div class = "card-body text-justify">
									<h2 class="manufacturer_name card-title">
										<a class = "product_link" href = "<?php print $row->link?>">
											<?php print $row->name?>
										</a>
									</h2>
									<p class = "manufacturer_short_description card-text">
										<?php print $row->short_description?>
									</p>
								</div>
								<?php if (!empty($row->manufacturer_url)) : ?>
									<div class="card-footer bg-white border-0 text-right">
										<a target="_blank" class="manufacturer_url badge" href="<?php print $row->manufacturer_url?>">
											<i class="fas fa-external-link-alt"></i> <?php print _JSHOP_MANUFACTURER_INFO?>
										</a>
									</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
                </div>

            <?php endforeach; ?>

        </div>
    </div>
    <?php endif; ?>
</div>