<?php 
/**
* @version      4.11.1 13.08.2013
* @author       MAXXmarketing GmbH
* @package      Jshopping
* @copyright    Copyright (C) 2010 webdesigner-profi.de. All rights reserved.
* @license      GNU/GPL
*/
defined('_JEXEC') or die();
?>
<div class="jshop myorders_list" id="comjshop">

    <h1><?php print _JSHOP_MY_ORDERS ?></h1>
    
    <?php print $this->_tmp_html_before_user_order_list;?>

    <?php if (count($this->orders)) {?>
        <div class="row">
                <?php foreach ($this->orders as $order){?>

                    <div class="card col-12 mb-3 shadow">
                        <div class="row no-gutters">
                            <div class="col-sm-6 col-md-3 d-flex flex-column justify-content-center align-items-center">
                                <span class="h2"><?php print formatprice($order->order_total, $order->currency_code)?></span>
	                            <?php print $order->_ext_price_html?>
                                 <span class="order_number">
                                    <span class="badge text-dark"><?php print _JSHOP_ORDER_NUMBER ?>:</span><span class="badge text-secondary"><?php print $order->order_number?></span>
                                     <?php print $order->_tmp_ext_order_number;?>
                                 </span>
                                <span class="order_status">
                                    <span class="badge text-dark"><?php print _JSHOP_ORDER_STATUS ?>:</span><span class="badge text-secondary"><?php print $order->status_name;?></span>
	                                <?php print $order->_tmp_ext_status_name;?>
                                </span>
                            </div>
                            <div class="col-sm-6 col-md-6">
                                <div class="card-body">
                                    <p class="card-text"><strong><?php print _JSHOP_PRODUCTS ?>:</strong> <span><?php print $order->count_products ?></span></p>
	                                <?php if(!empty($order->_tmp_ext_prod_info)){?>
                                        <p class="card-text"><?php print $order->_tmp_ext_prod_info;?></p>
	                                <?php }?>
                                    <p class="card-text"><strong><?php print _JSHOP_EMAIL_BILL_TO; ?>:</strong> <?php print $order->f_name; ?> <?php print $order->l_name; ?></p>
	                                <?php if(!empty($order->_tmp_ext_user_info)){?>
                                        <p class="card-text"><?php print $order->_tmp_ext_user_info;?></p>
	                                <?php }?>
                                    <p class="card-text"><small class="text-muted"><b><?php print _JSHOP_ORDER_DATE ?>:</b> <span><?php print formatdate($order->order_date, 0) ?></span></small></p>
                                </div>
                            </div>
                            <div class="col-sm-12 col-md-3 d-flex flex-column justify-content-center align-items-center">
                                <a class="btn btn-primary m-4 m-md-0" href = "<?php print $order->order_href ?>"><?php print _JSHOP_DETAILS?></a>
	                            <?php print $order->_tmp_ext_but_info;?>
                            </div>
                        </div>
                    </div>


	                <?php print $order->_tmp_ext_row_end;?>
                <?php } ?>

            <div class="myorders_total col-12 border-1 shadow p-3 text-center">
                <span class="name h3"><?php print _JSHOP_TOTAL?>:</span>
                <span class="price h2"><?php print formatprice($this->total, getMainCurrencyCode())?></span>
            </div>
        </div>
    <?php }else{ ?>
        <div class="myorders_no_orders">
            <?php print _JSHOP_NO_ORDERS ?>
        </div>
    <?php } ?>
    
    <?php print $this->_tmp_html_after_user_order_list;?>
</div>