<?php
/**
 * @package     WT Highlight.js
 * @version     1.1.1
 * @Author      Sergey Tolkachyov, https://web-tolk.ru
 * @copyright   Copyright (C) 2024 Sergey Tolkachyov
 * @license     GNU/GPL3
 * @since       1.0.0
 */

namespace Joomla\Plugin\Content\Wthighlightjs\Extension;

use Joomla\CMS\Application\CMSApplicationInterface;
use Joomla\String\StringHelper;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\Event\SubscriberInterface;

defined('_JEXEC') or die;

class Wthighlightjs extends CMSPlugin implements SubscriberInterface
{
    /**
     * Load the language file on instantiation.
     *
     * @var    boolean
     *
     * @since  3.9.0
     */
    protected $autoloadLanguage = true;
    
	protected $allowLegacyListeners  = false;

    /**
     * @inheritDoc
     *
     * @return string[]
     *
     * @throws Exception
     * @since 4.1.0
     *
     */
    public static function getSubscribedEvents(): array
    {

        return [
			'onContentPrepare' => 'onContentPrepare'
			];
    }


    /**
     * Plugin that adds a pagebreak into the text and truncates text at that point
     *
     * @param string $context The context of the content being passed to the plugin.
     * @param object   &$row The article object.  Note $article->text is also available
     * @param mixed    &$params The article params
     * @param integer $page The 'page' number
     *
     * @return  void
     *
     * @since   1.6
     */
    public function onContentPrepare($event) : void
    {
		$app = $this->getApplication();
		$context = $event->getArgument(0);
		$row = $event->getArgument(1);
		$params = $event->getArgument(2);
		$page = $event->getArgument(3);		
		// Don't run if in the API Application
        // Don't run this plugin when the content is being indexed
        if ($app->isClient('api') || $context === 'com_finder.indexer') {
            return;
        }
		

        // Expression to search for.
        $regex = '#<pre><code class="language-(.*)"\/?>#iU';

//        // Simple performance check to determine whether bot should process further.
//        if (StringHelper::strpos($row->text, 'class="system-pagebreak') === false) {
//            if ($page > 0) {
//                throw new Exception(Text::_('JERROR_PAGE_NOT_FOUND'), 404);
//            }
//
//            return;
//        }

        // Find all instances of plugin and put in $matches.
        $matches = [];
        preg_match_all($regex, $row->text, $matches, PREG_SET_ORDER);


        if(count($matches) > 0)
        {
            
            /** @var Joomla\CMS\WebAsset\WebAssetManager $wa */
            $wa = $app->getDocument()->getWebAssetManager();

            $wa->registerAndUseScript('highlight.js', 'plg_content_wthighlightjs/highlight.js');
            if($this->params->get('color_scheme_type','default') == 'base16'){
                $color_scheme = $this->params->get('color_scheme_base16','colors.min.css');
                $wa->registerAndUseStyle('highlight.js','media/plg_content_wthighlightjs/css/base16/'.$color_scheme);
            } else{
                $color_scheme = $this->params->get('color_scheme','default.min.css');
                $wa->registerAndUseStyle('highlight.js','plg_content_wthighlightjs/'.$color_scheme);
            }

            foreach ($matches as $match)
			{
                $lang = $match[1];

                $wa->registerAndUseScript('highlight.js.'.$lang, 'media/plg_content_wthighlightjs/js/languages/'.$lang.'.min.js');
                // media/plg_content_wthighlightjs/js/languages
            }

            $wa->addInlineScript('hljs.highlightAll();');

        }

        // Split the text around the plugin.

    }
}
