<?php
/**
 * @package    Fields - WT Layout select
 * @version    1.0.0
 * @Author     Sergey Tolkachyov, https://web-tolk.ru
 * @copyright  Copyright (C) 2026 Sergey Tolkachyov
 * @license    GNU/GPL http://www.gnu.org/licenses/gpl-3.0.html
 * @since  v.1.0.0
 */

declare(strict_types=1);

namespace Joomla\Plugin\Fields\Wtlayoutselect\Fields;

use Joomla\CMS\Factory;
use Joomla\CMS\Form\Field\NoteField;
use Joomla\CMS\Language\Text;

\defined('_JEXEC') or die;

final class PlugininfoField extends NoteField
{
    protected $type = 'Plugininfo';

    /**
     * The spacer does not have input, return a single space.
 * @since  v.1.0.0
 */
    protected function getInput(): string
    {
        return ' ';
    }

    /**
     * Builds plugin info card with version and description.
 * @since  v.1.0.0
 */
    protected function getLabel(): string
    {
        $data = $this->form->getData();
        $element = (string) $data->get('element');
        $folder = (string) $data->get('folder');
        $version = '';

        if (!empty($element) && !empty($folder)) {
            $manifestPath = JPATH_SITE . '/plugins/' . $folder . '/' . $element . '/' . $element . '.xml';

            if (is_file($manifestPath)) {
                $pluginInfo = simplexml_load_file($manifestPath);

                if ($pluginInfo !== false && isset($pluginInfo->version)) {
                    $version = (string) $pluginInfo->version;
                }
            }
        }

        $doc = Factory::getApplication()->getDocument();
        $doc->getWebAssetManager()->addInlineStyle(
            '#web_tolk_link{text-align:center;}#web_tolk_link::before{content:"";}'
        );

        return '</div>
        <div class="card container shadow-sm w-100 p-0">
            <div class="wt-b24-plugin-info row">
                <div class="col-12 col-md-2 d-flex justify-content-center align-items-center">
                    <a href="https://web-tolk.ru" target="_blank" id="web_tolk_link" title="Go to https://web-tolk.ru">
                        <svg width="200" height="50" viewBox="0 0 100 50" xmlns="http://www.w3.org/2000/svg">
                            <g>
                                <title>Go to https://web-tolk.ru</title>
                                <text font-weight="bold" xml:space="preserve" text-anchor="start" font-family="Helvetica, Arial, sans-serif" font-size="32" y="36.085949" x="8.152073" stroke-opacity="null" stroke-width="0" stroke="#000" fill="#0fa2e6">Web</text>
                                <text font-weight="bold" xml:space="preserve" text-anchor="start" font-family="Helvetica, Arial, sans-serif" font-size="32" y="36.081862" x="74.239105" stroke-opacity="null" stroke-width="0" stroke="#000" fill="#384148">Tolk</text>
                            </g>
                        </svg>
                    </a>
                </div>
                <div class="col-12 col-md-10">
                    <div class="card-header bg-transparent p-1">
                        <span class="badge bg-success">v.' . $version . '</span>
                    </div>
                    <div class="card-body">'
                        . Text::_('PLG_FIELDS_WTLAYOUTSELECT_DESC') .
                    '</div>
                </div>
            </div>
        </div><div>';
    }

    /**
     * Returns field title markup.
 * @since  v.1.0.0
 */
    protected function getTitle(): string
    {
        return $this->getLabel();
    }
}

