/******/ (() => { // webpackBootstrap
/******/ 	/************************************************************************/
/*!***********************************************!*\
  !*** ./plg_content_wtviewpdf/es6/default.es6 ***!
  \***********************************************/
document.addEventListener('DOMContentLoaded', () => {
  const elements = document.querySelectorAll('.wtviewpdf-default');
  elements.forEach(element => {
    const file_url = element.getAttribute('data-file-url');
    const pdfContainer = element.querySelector('.pdf-container');
    var {
      pdfjsLib
    } = globalThis;
    let url = window.location.origin + '/' + file_url;
    let scale = 2;
    async function loadPDF(pdfUrl) {
      const loadingTask = pdfjsLib.getDocument(pdfUrl);
      const pdf = await loadingTask.promise;
      const canvases = [];
      for (let i = 1; i <= pdf.numPages; i++) {
        const page = await pdf.getPage(i);
        const viewport = page.getViewport({
          scale: 2
        });
        const canvas = document.createElement('canvas');
        const context = canvas.getContext('2d');
        canvas.height = viewport.height;
        canvas.width = viewport.width;
        canvas.setAttribute('data-page-num', i);
        const renderContext = {
          canvasContext: context,
          viewport: viewport
        };
        await page.render(renderContext).promise;
        canvases.push(canvas);
      }
      return canvases;
    }
    loadPDF(url).then(canvases => {
      canvases.forEach((canvas, index) => {
        pdfContainer.appendChild(canvas);
        console.log(`Page ${index + 1} appended.`);
      });
    }).catch(error => {
      console.error('Error loading PDF: ', error);
    }).then(() => {});
  });
});
/******/ })()
;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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