<?php
/**
 * @package    WT Look in frontend
 * @version    1.0.0
 * @author     Sergey Tolkachyov
 * @сopyright  Copyright (c) 2025 Sergey Tolkachyov. All rights reserved.
 * @license    GNU/GPL license: https://www.gnu.org/copyleft/gpl.html
 * @link       https://web-tolk.ru
 */

namespace Joomla\Plugin\System\Wtlookinfrontend\Extension;

use Joomla\CMS\Plugin\CMSPlugin;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Toolbar\Button\LinkButton;
use Joomla\Event\SubscriberInterface;
use Joomla\CMS\Language\Text;

use function defined;

defined('_JEXEC') or die;

class Wtlookinfrontend extends CMSPlugin implements SubscriberInterface
{
	
	protected $autoloadLanguage = true;
	
	/**
	 * Returns an array of events this subscriber will listen to.
	 *
	 * @return  array
	 *
	 * @since   4.0.0
	 */
	public static function getSubscribedEvents(): array
	{
		return [
			'onAfterDispatch' => 'onAfterDispatch',
		];
	}

	/**
	 * Adding a link button to the material from the outside to the toolbar on the material editing page
	 *
	 * @since 1.0.0
	 */
	public function onAfterDispatch()
	{
		if (!$this->getApplication()->isClient('administrator'))
		{
			return;
		}

		if ($this->getApplication()->getInput()->get('option') !== 'com_content')
		{
			return;
		}

		if (empty($this->getApplication()->getInput()->getInt('id')))
		{
			return;
		}

		$toolbar = $this->getApplication()->getDocument()->getToolbar('toolbar');
		$linkMode = $this->getApplication()->get('force_ssl', 0) == 2 ? Route::TLS_FORCE : Route::TLS_IGNORE;
		$link = Route::link('site','index.php?option=com_content&view=article&id=' . $this->getApplication()->getInput()->getInt('id'), false, $linkMode,true);
		$button = (new LinkButton('wt_look_in_frontend'))
			->url($link)
			->text(Text::_('PLG_WTLOOKINFRONTEND_BTN_TEXT'))
			->buttonClass('btn btn-warning')
			->target('_blank')
			->icon('icon-eye');
		$toolbar->appendButton($button);

		$this->getApplication()
			->getDocument()
			->getWebAssetManager()
			->addInlineStyle('#toolbar-wt_look_in_frontend{background-color:var(--warning)}, border-color:var(--warning)}');

	}

}
