<?php
/**
 * @version      1.5.0 12.06.2020
 * @author       Sergey Tolkachyov
 * @copyright    Copyright (C) 2019 Sergey Tolkachyov. All rights reserved.
 * @license      GNU/GPL
 */

use Joomla\CMS\Factory;
use Joomla\CMS\Version;

defined('_JEXEC') or die('Restricted access');

class sm_pochta_ru extends shippingextRoot
{
	function showShippingPriceForm($params, &$shipping_ext_row, &$template)
	{
		include(dirname(__FILE__) . "/shippingpriceform.php");
	}


	function showConfigForm($config, &$shipping_ext, &$template)
	{
		$checkedNo    = $checkedYes = '';
		$checkeNDSdNo = $checkedNDSYes = '';
		if ($config['debug'])
		{
			$checkedYes = 'checked="checked"';
		}
		else
		{
			$checkedNo = 'checked="checked"';
		}

		include(dirname(__FILE__) . "/configform.php");
	}


	function getPrice($cart, $params, $price, &$shipping_ext_row, &$shipping_method_price)
	{


//параметры способа доставки
		$sm_params = unserialize($shipping_ext_row->params);
		//загружаем пользователя
		$user = Factory::getUser();
		if ($user->id)
		{
			$user_info = JSFactory::getUserShop();

		}
		else
		{
			$user_info = JSFactory::getUserShopGuest();
		}


		//вычисляем стоимость доставки
		$price_shipping = $this->calculatePrice($user_info, $cart, $params, $sm_params, $shipping_method_price);

		//если стоимость доставки не определена
		if (!$price_shipping)
		{
			$price_shipping = '0';
		}

		if ($sm_params["zero_cost"] == 1 && ($price_shipping == '0' or $price_shipping == ''))
		{
			echo " <script>
					jQuery(document).ready(function(){
						jQuery('input#shipping_method_" . $shipping_method_price->shipping_method_id . "').attr('disabled','disabled');
					});
			</script>";
		}
		elseif ($sm_params["zero_cost"] == 2 && ($price_shipping == '0' or $price_shipping == ''))
		{
			echo " <script>
					jQuery(document).ready(function(){
						jQuery('input#shipping_method_" . $shipping_method_price->shipping_method_id . "').attr('disabled','disabled').css('display','none');
						jQuery('label[for=shipping_method_" . $shipping_method_price->shipping_method_id . "]').css('display','none');
					});
			</script>";
		}

		return $price_shipping;


	}

	private function calculatePrice($user_info, $cart, $params, $sm_params, $shipping_method_price)
	{

		$debug          = (!empty($sm_params['debug'])) ? (int) $sm_params['debug'] : 0;
		$display_errors = (!empty($sm_params['display_errors'])) ? (int) $sm_params['display_errors'] : 0;
		$price_tax      = (!empty($sm_params['price_tax'])) ? (int) $sm_params['price_tax'] : 0;
		$weight_factor  = (float) str_replace(',', '.', $sm_params['weight_factor']);
		$weight_factor  = ($weight_factor == 0) ? $weight_factor = 1 : $weight_factor;
		if (!$weight_factor)
		{
			$weight_factor = 1;
		} //Если не указан коэффициент поправки веса, то умножаем вес на 1
		$general_factor = (float) str_replace(',', '.', $sm_params['general_factor']);
		$general_factor = ($general_factor == 0) ? $general_factor = 1 : $general_factor;
		//сумма счета
		$summ = (int)$cart->price_product_brutto;
		//вес
		$weight = (int)$cart->getWeightProducts();
		//Коэффициент поправки веса
		$weight = round($weight * $weight_factor);

		include(dirname(__FILE__) . "/const.php");


		//Собираем информацию для формирования url запроса
		$index_fromForDebug = $sm_params['index_from'];
		$index_from         = "&from=" . $sm_params['index_from'];//Индекс отправителя
		$index_toForDebug   = $user_info->zip;
		$index_to           = "&to=" . $user_info->zip;// Индекс получателя
		$weight_measure     = $sm_params['weight_measure'];// в чем единицы измерения веса товара
		if ($weight_measure == 1)
		{// Если в килограммах, то умножаем на 1000. Тарификатор считает все в граммах
			$weight = $weight * 1000;
		}

		if ($weight < $minweight)
		{
			$weight = $minweight;//Минимальный вес отправления 100 грамм. Если меньше, то увеличиваем до 100 грамм. Иначе ошибка.
		}
		$weightForDebug = $weight;

		if ($weight > 31500 && $display_errors == 1)
		{
			$how_many_orders = ceil($weight / 31500);

			echo "<div class='alert alert-danger'>
			<h3>Общий вес заказа (" . ($weight / 1000) . ") превышает допустимое значение</h3>
			<p>Максимально допустимое значение - 31,5кг.</p>
			<p><strong>Ваш заказ необходимо разделить на " . $how_many_orders . "</strong></p>
			</div>
			<script>
			jQuery(document).ready(function(){
				jQuery('[for=shipping_method_" . $shipping_method_price->shipping_method_id . "]').css('color','red').append('<br/><strong>Превышен максимально допустимый вес</strong>');
			});
			</script>
			";
			$weight_warning = 0;

			return $weight_warning;

		}
		else
		{
			$weight      = "&weight=" . $weight;
			$object_type = "&object=" . $params['tip_otpravleniya'];
			foreach ($tipOtpravleniya as $value)
			{
				if ($value["code"] == $params['tip_otpravleniya'])
				{
					if ($value["pack"] == 1)
					{
						$pack = "&pack=" . $params["pack"];
					}
					else
					{
						$pack = "";
					}
					if ($value["international"] == 1)
					{
						$country_code2 = $this->getCountryCode2($user_info->country);
						$country       = $countries_pochta_ru_codes[$country_code2];

						$country = "&country=" . $country;
					}
					else
					{
						$country = "";
					}
				}
			}
			$sumoc = $params["sumoc"];//Объявленная ценность
			if (!$sumoc)
			{
				$sumoc = "";
			}
			else
			{
				$sumoc = $params["sumoc"] * 100;//Сумма в копейках
				$sumoc = "&sumoc=" . $sumoc;
			}

			$sumnp = $params["sumnp"];//Сумма наложенного платежа
			if (!$sumnp)
			{
				$sumnp = "";
			}
			else
			{
				$sumnp = $params["sumnp"] * 100;//Сумма в копейках
				$sumnp = "&sumnp=" . $sumnp;
			}
			//запрашиваем стоимость перевозки
			$url = "https://tariff.pochta.ru/tariff/v1/calculate?jsontext" . $object_type . $index_from . $index_to . $weight . $pack . $sumoc . $sumnp . $country;

			if ((new Version())->isCompatible('4.0'))
			{
				$http = (new \Joomla\Http\HttpFactory)->getHttp(array(), ['curl', 'stream']);
			}
			else
			{
				$http = \Joomla\CMS\Http\HttpFactory::getHttp(null, ['curl', 'stream']);
			}
			$response = $http->get($url);
			if ((int) $response->code >= 200 && (int) $response->code < 300)
			{
				$tariff_array = json_decode($response->body, true);
			}
			else
			{
				Factory::getApplication()->enqueueMessage('<span class=\"alert-link\">Ошибка рассчета доставки:</span> <br/>Отсутствует соединение с сервером расчета доставки<br/><span class=\"alert-link\">Свяжитесь, пожалуйста, с администратором сайта.</span>', 'error');
			}

			if ($tariff_array["error"] && $display_errors == 1)
			{
				Factory::getApplication()->enqueueMessage('<span class=\"alert-link\">Ошибка рассчета доставки:</span> <br/>".$tariff_array["error"][0]."<br/><span class=\"alert-link\">Свяжитесь, пожалуйста, с администратором сайта.</span>', 'error');
			}


			$showNDS = $sm_params['nds'];// Тарификатор отдает 2 цены: с НДС и без. Выбираем, что показывать
			if ($showNDS == 0)
			{
				$price = (int)$tariff_array["pay"] / 100;
			}
			elseif ($showNDS == 1)
			{
				$price   = (int)$tariff_array["paynds"] / 100;
				$nds     = (int)$tariff_array["nds"] / 100;
				$ndsrate = $tariff_array["ndsrate"];
				$name    = $tariff_array["name"];
			}

			if ($price_tax != 0)
			{
				$price_tax = ($summ / 100) * $price_tax;
			}//Если наценка не указана, то коэффициент = 0.
			if (!$general_factor)
			{
				$general_factor = 1;
			}

			$prices = ($price + $price_tax) * $general_factor;
			/**
			 * DEBUG SECTION
			 */
			if ($debug == 1)
			{
				$sh_method = JSFactory::getTable('shippingMethod', 'jshop');
				$sh_method->load($shipping_method_price->shipping_method_id);
				$language_tag         = Factory::getLanguage()->getTag();
				$sh_method_name = $sh_method->{'name_' . $language_tag};
				include(dirname(__FILE__) . "/debug.php");
			}

			return $prices;
		}
	}

	/** Returns country code by id
	 *
	 * @param   Int  $country_id
	 *
	 * @return string   country code2
	 *
	 * @since version 1.5
	 */
	private function getCountryCode2($country_id)
	{
		$db    = Factory::getDBO();
		$query = $db->getQuery(true);
		$query->select($db->quoteName('country_code_2'))
			->from($db->quoteName('#__jshopping_countries'))
			->where($db->quoteName('country_id') . ' = ' . $db->quote($country_id));
		$db->setQuery($query);
		$country_code2 = $db->loadAssoc();

		return $country_code2["country_code_2"];
	}
}

?>