<?php
/**
 * @package     WT SP Easy Image Galler insert
 * @copyright   (C) 2023 Sergey Tolkachyov <https://web-tolk.ru>
 * @link 		https://web-tolk.ru/dev/joomla-plugins/wt-highlight-js.html
 * @license     GNU General Public License version 3 or later
 */
// No direct access to this file
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Installer\Installer;
use Joomla\CMS\Installer\InstallerHelper;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Plugin\PluginHelper;
use Joomla\CMS\Version;

/**
 * Script file of HelloWorld component.
 *
 * The name of this class is dependent on the component being installed.
 * The class name should have the component's name, directly followed by
 * the text InstallerScript (ex:. com_helloWorldInstallerScript).
 *
 * This class will be called by Joomla!'s installer, if specified in your component's
 * manifest file, and is used for custom automation actions in its installation process.
 *
 * In order to use this automation script, you should reference it in your component's
 * manifest file as follows:
 * <scriptfile>script.php</scriptfile>
 *
 * @package     Joomla.Administrator
 * @subpackage  com_helloworld
 *
 * @copyright   Copyright (C) 2005 - 2018 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
class plgContentWtspeiginsertInstallerScript
{
	/**
	 * This method is called after a component is installed.
	 *
	 * @param   \stdClass  $parent  - Parent object calling this method.
	 *
	 * @return void
	 */
	public function install($installer)
	{
    	// Prepare plugin object
		$plugin          = new stdClass();
		$plugin->type    = 'plugin';
		$plugin->element = $installer->getElement();
		$plugin->folder  = (string) $installer->getParent()->manifest->attributes()['group'];
		$plugin->enabled = 1;

		// Update record
		Factory::getContainer()->get('DatabaseDriver')->updateObject('#__extensions', $plugin, array('type', 'element', 'folder'));
	}
}